/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

rtc_time_t time;
rtc_date_t date;

void pin_init(void)
{
	gpio_init_t x;

	/* Initialize PA0_WKUP-TAMPER1_RTC #0 pin */
	x.mode = GPIO_MODE_INPUT;
        x.odos = GPIO_OPEN_SOURCE;
        x.pupd = GPIO_PUSH_UP;
        x.odrv = GPIO_OUT_DRIVE_NORMAL;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_TTL;
	x.func = GPIO_FUNC_1;
	ald_gpio_init(RTC_TAMPER_PORT, RTC_TAMPER_PIN, &x);
}

/**
  * @brief  Test RTC time and date functions
  * @retval Status.
  */
int main()
{
	rtc_init_t init;
	rtc_tamper_t tamper;

	/* Initialize ALD */
	ald_cmu_init();

        pin_init();

	/* Enable RTC interrupt */
	ald_mcu_irq_config(RTC_TSENSE_IRQn, 3, ENABLE);

	/* Initialize RTC */
	init.asynch_pre_div  = 0;
	init.synch_pre_div   = 32767;
	init.hour_format     = RTC_HOUR_FORMAT_24;
	init.output          = RTC_OUTPUT_DISABLE;
	init.output_polarity = RTC_OUTPUT_POLARITY_HIGH;
	ald_rtc_init(&init);

	/* Set current time and date */
	time.hour    = 21;
	time.minute  = 22;
	time.second  = 43;
	date.day     = 11;
	date.month   = 9;
	date.year    = 17;
	date.week    = 1;
	ald_rtc_set_time(&time, RTC_FORMAT_DEC);
	ald_rtc_set_date(&date, RTC_FORMAT_DEC);

	/* Configure tamper parameters */
	tamper.idx  = RTC_TAMPER_1;
	tamper.trig = RTC_TAMPER_TRIGGER_LOW;
	tamper.freq = RTC_TAMPER_SAMPLING_FREQ_256;
	tamper.dur  = RTC_TAMPER_DURATION_1;
	tamper.ts   = DISABLE;                          
	ald_rtc_set_tamper(&tamper);

	/* Enable second interrupt */
	ald_rtc_interrupt_config(RTC_IT_TP1, ENABLE);
	
	while (1) {
		ald_delay_ms(1000);
	}
}

void rtc_tamper_handler(void)
{
	/* Check and clear interrupt flag */
	ald_rtc_get_flag_status(RTC_IF_TP1);
	ald_rtc_clear_flag_status(RTC_IF_TP1);

	/* Cancel time stamp */
	ald_rtc_cancel_tamper(RTC_TAMPER_1);
}

/**
  * @}
  */
/**
  * @}
  */
