/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include <string.h>
#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();

	/* Set BOR */
	ald_rmu_bor_config(RMU_BORFLT_2, RMU_VOL_2_8, ENABLE);
	/* Get reset status */
	ald_rmu_get_reset_status(RMU_RST_CPU);
	/* Clear reset state */
	ald_rmu_clear_reset_status(RMU_RST_CPU);
	/* Reset SPI0 */
	ald_rmu_reset_periperal(RMU_PERH_SPI0);
	/* Reset WDT */
	ald_rmu_reset_periperal(RMU_PERH_WWDT);
	/* Reset GPIO */
	ald_rmu_reset_periperal(RMU_PERH_GPIO);

	while (1) {
		ald_delay_ms(1000);
	}
}
/**
  * @}
  */

/**
  * @}
  */
