/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

lptim_handle_t h_lptim;
lptim_trigger_init_t trigger_config;
lptim_clock_source_init_t clock_config;

/**
  * @brief  Initializate pin of lptim module.
  * @retval None
  */
void lptim_pin_init(void)
{
	gpio_init_t a;
        pis_handle_t y;
	
	/* Initialize lptim0 output pin */
	a.mode = GPIO_MODE_OUTPUT;
	a.odos = GPIO_PUSH_PULL;
	a.pupd = GPIO_PUSH_UP;
	a.odrv = GPIO_OUT_DRIVE_NORMAL;
	a.flt  = GPIO_FILTER_DISABLE;
	a.type = GPIO_TYPE_TTL;
	a.func = GPIO_FUNC_2;	
	ald_gpio_init(LPTIMER_OUTPUT_PORT, LPTIMER_OUTPUT_PIN, &a);
    
        a.mode = GPIO_MODE_INPUT;
	a.odos = GPIO_PUSH_PULL;
	a.pupd = GPIO_PUSH_UP;
	a.odrv = GPIO_OUT_DRIVE_NORMAL;
	a.flt  = GPIO_FILTER_DISABLE;
	a.type = GPIO_TYPE_TTL;
	a.func = GPIO_FUNC_1;	
	ald_gpio_init(LPTIMER_TRIGGER_PORT, LPTIMER_TRIGGER_PIN, &a);
    
        y.perh = PIS;
        y.init.producer_src = PIS_GPIO_PIN4;
        y.init.producer_clk = PIS_CLK_PCLK1;
        y.init.producer_edge= PIS_EDGE_NONE;
        y.init.consumer_trig= PIS_CH0_LPTIM0_EXT0;
        y.init.consumer_clk = PIS_CLK_PCLK1;
    
        y.consumer_ch = PIS_CH_0;
    
        ald_pis_create(&y);
}

/**
  * @brief  Compare complete.
  * @param  arg: Pointer to lptim_handle_t structure.
  * @retval None.
  */
void compare_complete(lptim_handle_t *arg)
{
	return;
}

/**
  * @brief  updata complete.
  * @param  arg: Pointer to lptim_handle_t structure.
  * @retval None.
  */
void updata_complete(lptim_handle_t *arg)
{
	return;
}

/**
  * @brief  External trigger complete.
  * @param  arg: Pointer to lptim_handle_t structure.
  * @retval None.
  */
void external_trigger_complete(lptim_handle_t *arg)
{
	ald_lptim_clear_flag_status(&h_lptim, LPTIM_FLAG_EXTTRIG);
}

/**
  * @brief  This is main function
  * @retval Status
  */

int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
    
    
        ald_mcu_irq_config(LPTIM0_SPI2_IRQn, 1, ENABLE);
	
	/* Initialize LPTIM0 */
	lptim_pin_init();
	
	/* Initialize LPTIM0 */
	h_lptim.perh       = LPTIM0;
	h_lptim.init.psc   = LPTIM_PRESC_1;
	h_lptim.init.arr   = 0x0FFF;
	h_lptim.init.cmp   = 0X0C00;
	h_lptim.init.mode  = LPTIM_MODE_CONTINUOUS;
        h_lptim.trig_cbk   = external_trigger_complete;
	h_lptim.trig_cbk   = external_trigger_complete;
	h_lptim.update_cbk = updata_complete;
	h_lptim.cmp_cbk    = compare_complete;
	ald_lptim_pwm_init(&h_lptim);
		
	
	/* Initialize clock source */
	clock_config.sel      = LPTIM_CKSEL_INTERNAL;
	clock_config.polarity = LPTIM_CKPOL_RISING;
	ald_lptim_clock_source_config(&h_lptim, &clock_config);
	
	/* Initialize pulse */
	trigger_config.mode = LPTIM_TRIGEN_RISING;
        trigger_config.sel  = LPTIM_TRIGSEL_EXT0;
	ald_lptim_trigger_config(&h_lptim, &trigger_config);
	
        ald_lptim_interrupt_config(&h_lptim, LPTIM_IT_EXTTRIG,ENABLE);
	/* Start pulse start */
	ald_lptim_pwm_start(&h_lptim);
	
	while(1);
}

/**
  * @}
  */
/**
  * @}
  */
