/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

uint32_t value = 0;
lptim_handle_t h_lptim;
lptim_trigger_init_t _trig;
lptim_clock_source_init_t _clock;


/**
  * @brief  updata complete.
  * @param  arg: Pointer to lptim_handle_t structure.
  * @retval None.
  */
void updata_complete(lptim_handle_t *arg)
{
	++value;
	return;
}

/**
  * @brief  This is main function
  * @retval Status
  */

int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);

	memset(&h_lptim, 0x0, sizeof(lptim_handle_t));
	memset(&_trig, 0x0, sizeof(lptim_trigger_init_t));
	memset(&_clock, 0x0, sizeof(lptim_clock_source_init_t));
        ald_mcu_irq_config(LPTIM0_SPI2_IRQn, 1, ENABLE);

	/* Initialize LPTIM0 */
	h_lptim.perh       = LPTIM0;
	h_lptim.init.psc   = LPTIM_PRESC_1;
	h_lptim.init.arr   = 0x9FFF;
        h_lptim.init.clock = CMU_LP_PERH_CLOCK_SEL_LRC;
	h_lptim.init.mode  = LPTIM_MODE_CONTINUOUS;
	h_lptim.trig_cbk   = NULL;
	h_lptim.update_cbk = updata_complete;
	h_lptim.cmp_cbk    = NULL;
	ald_lptim_base_init(&h_lptim);

	/* Initialize clock source */
	_clock.sel      = LPTIM_CKSEL_INTERNAL;
	_clock.polarity = LPTIM_CKPOL_RISING;
	ald_lptim_clock_source_config(&h_lptim, &_clock);

	/* Initialize toggle */
	_trig.mode = LPTIM_TRIGEN_SW; 
	ald_lptim_trigger_config(&h_lptim, &_trig);

        ald_lptim_interrupt_config(&h_lptim,LPTIM_IT_ARRMAT,ENABLE);
	/* Start LPTIM0 */
	ald_lptim_base_start(&h_lptim);

	while(1) {
		ald_delay_ms(1000);
	}
}
/**
  * @}
  */
/**
  * @}
  */
