/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for Demo
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include "main.h"
#include <stdlib.h>
#include <string.h>

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples_FLASH
  * @{
  */

uint8_t loop = 0;
uint16_t len = 100;
uint8_t buffer[100] = {0};
uint32_t read[100] = {0};
uint32_t address = 10 * FLASH_PAGE_SIZE;

/**
  * @brief  This is main function
  * @retval Status
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();

	/* Initialize data array */
	for (loop = 0; loop < len; loop++)
		buffer[loop] = loop;
	
	/* Write data to flash */
	ald_flash_write(address, buffer, len);
	
	/* Read data from the flash address you write */
	ald_flash_read(read, address, len);
	
	 /* Erase flash */
	ald_flash_erase(address, len);
	
	/* Check if erase succeed */
	ald_flash_read(read, address, len);
	
	while(1) {
		ald_delay_ms(1000);
	}
}
/**
  * @}
  */
/**
  * @}
  */
