/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#include "main.h"
#include <string.h>

  
/** @addtogroup Projects_Examples_ALD
  * @{
  */


/** @addtogroup Public_Function
  * @{
  */

uint8_t loop  = 0;
uint8_t count = 0;
uint8_t error = 0;
uint32_t plain[16] = {0x3243F6A8, 0x885A308D, 0x313198A2, 0xE0370734,
                      0x3243F6A8, 0x885A308D, 0x313198A2, 0xE0370734,
                      0x3243F6A8, 0x885A308D, 0x313198A2, 0xE0370734,
                      0x3243F6A8, 0x885A308D, 0x313198A2, 0xE0370734};
uint32_t result[16] = {0};
uint32_t expect[16] = {0x925afa80, 0x48a07d7a, 0xd868c5f2, 0xc39468a6,
                       0x1db9bf55, 0xf0be8867, 0x5f04cbc2, 0xfac9578c, 
                       0xf4a47fad, 0x5961e322, 0xd6a04406, 0x01754289, 
                       0x1c22ee2f, 0xa04608aa, 0xc22f6429,0x9240066d};
uint32_t key[4] = {0x2b7e1516, 0x28aed2a6, 0xabf71588, 0x09cf4f3c};
uint32_t ivr[4] = {0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff};

/**
  * @brief  crypt completed callback.
  * @param  arg: Pointer to crypt_handle_t structure.
  * @retval None.
  */
void crypt_complete(crypt_handle_t *arg)
{
	++count;
	return;
}

/**
  * @brief  crypt error callback.
  * @param  arg: Pointer to crypt_handle_t structure.
  * @retval None.
  */
void error_complete(crypt_handle_t *arg)
{
	++error;
	return;
}
crypt_handle_t h_crypt;

/* aes cbc key = 128bits
 * input 	32 43 f6 a8 88 5a 30 8d 31 31 98 a2 e0 37 07 34
 *		32 43 f6 a8 88 5a 30 8d 31 31 98 a2 e0 37 07 34
 *		32 43 f6 a8 88 5a 30 8d 31 31 98 a2 e0 37 07 34
 *		32 43 f6 a8 88 5a 30 8d 31 31 98 a2 e0 37 07 34
 * cipher key	2b 7e 15 16 28 ae d2 a6 ab f7 15 88 09 cf 4f 3c
 * iv		f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 fa fb fc fd fe ff
 * refer result	92 5a fa 80 48 a0 7d 7a d8 68 c5 f2 c3 94 68 a6
		1d b9 bf 55 f0 be 88 67 5f 04 cb c2 fa c9 57 8c 
		f4 a4 7f ad 59 61 e3 22 d6 a0 44 06 01 75 42 89 
		1c 22 ee 2f a0 46 08 aa c2 2f 64 29 92 40 06 6d
 */
void test_aes_cbc_128()
{
	/* Clear lpuart_handle_t structure */
	memset(&h_crypt, 0x0, sizeof(crypt_handle_t));

	/* Initialize crypt */
	h_crypt.perh           = CRYPT;
	h_crypt.init.mode      = CRYPT_MODE_CBC;//CRYPT_MODE_CBC
	h_crypt.init.type      = DATA_32_BIT;
	h_crypt.crypt_cplt_cbk = crypt_complete;
	h_crypt.err_cplt_cbk   = error_complete;
	ald_crypt_init(&h_crypt);

	/* Start AES encrypt */
	ald_crypt_write_key(&h_crypt, key);
	ald_crypt_write_ivr(&h_crypt, ivr);
	ald_crypt_encrypt_by_it(&h_crypt, (uint8_t*)plain, (uint8_t*)result, sizeof(plain));

	ald_delay_ms(3000);
	
	/* Start AES decrypt */	
	ald_crypt_write_key(&h_crypt, key);
	ald_crypt_write_ivr(&h_crypt, ivr);
 	ald_crypt_decrypt_by_it(&h_crypt, (uint8_t*)expect, (uint8_t*)result, sizeof(expect));	
}



/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{	
	/* Initialize ALD */
	ald_cmu_init();
	ald_mcu_irq_config(CRYPT_TRNG_IRQn, 3, ENABLE);
	test_aes_cbc_128();
	
	while (1) {
		ald_delay_ms(1000);
	}
}

/**
  * @}
  */

/**
  * @}
  */
