/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for demo
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include <string.h>
#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples_CALC
  * @{
  */

/**
  * @brief  Test main function
  * @retval Status.
  */
uint32_t ret, rem;
int32_t _ret, _rem;
int main()
{

	/* Initialize ALD */
	ald_cmu_init();

	/* Calculate Square root */
	ret = ald_calc_sqrt(256);
	/* Calculate division without signal */
	ret = ald_calc_div(256, 32, &rem);
	/* Calculate division with signal */
	_ret = ald_calc_div_sign(1256, -92, &_rem);
	/* Get DZ flag */
	ald_calc_get_dz_status();

	while (1) {
		ald_delay_ms(1000);
	}
}
/**
  * @}
  */

/**
  * @}
  */
