/**********************************************************************************
 *
 * @file    interrupt.c
 * @brief   Interrupt C file
 *
 * @date    23 Nov 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          23 Nov  2021    Ginger          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include "Interrupt.h"
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
/* Private Function ---------------------------------------------------------- */

/** @addtogroup Projects_Examples
  * @{
  */

/** @addtogroup INTERRUPT
  * @{
  */

/** @addtogroup Exceptions Handlers
  * @{
  */

/******************************************************************/
/*                Core Processor Exceptions Handlers           */
/******************************************************************/

void NMI_Handler(void)
{
}

void HardFault_Handler(void)
{
    while (1);

}

void SVC_Handler(void)
{
}

void PendSV_Handler(void)
{
}

void SysTick_Handler(void)
{
}

/******************************************************************/
/*              External Processor Exceptions Handlers            */
/******************************************************************/

void BS16T1_IRQHandler(void)        /*  IRQ 14  */
{
    BS16T1->ICR = BS16T1->IFM;

    /*BS16T1只有1个中断源，因此不用判断*/
    g_adc_temperature_hrc4m_handle_flag = 1;
}

/**
  * @} Exceptions Handlers
  */

/**
  * @} INTERRUPT
  */

/**
  * @} Projects_Examples
  */
/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/
