/**********************************************************************************
 *
 * @file    .h
 * @brief   header file of main.c
 *
 * @date    23 Nov 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          23 Nov  2021    Ginger          the first version
 *          28 Mar  2022    AE Team         Modify MD Driver
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __HRC4M_HANDLE_H__
#define __HRC4M_HANDLE_H__

/* Includes ------------------------------------------------------------------ */
#include <stdio.h>
#include <stdint.h>
#include "es32f0283.h"

#include "md_tick.h"
#include "md_rcu.h"
#include "md_syscfg.h"
#include "md_gpio.h"
#include "md_csu.h"
#include "md_adc.h"

/* Exported Macros ----------------------------------------------------------- */
/* Exported Variables -------------------------------------------------------- */
/* Exported Constants ------------------------------------------------------- */
/* Exported Functions ------------------------------------------------------ */ 
void adc_temperature_hrc4m_handle_init(void);
void adc_temperature_hrc4m_handle(void);
/* Exported Types ---------------------------------------------------------- */

#endif/*__HRC4M_HANDLE_H__*/
/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/

