/**********************************************************************************
 *
 * @file    mscfs_host.h
 * @brief   Head File
 *
 * @date    5 May 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 May 2022      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef _MSCFS_HOST_H
#define _MSCFS_HOST_H

//Define LUN Informaton
typedef struct  _LUN_ENTRY_
{
    uint32_t    MBREntry;
    uint32_t    BPBEntry;
    uint32_t    FAT0Entry;
    uint32_t    FAT1Entry;
    uint32_t    FirstDataLBA;
    uint32_t    RootCluster;        //for FAT32
    uint16_t    RootLBA;                //for FAT16
    uint8_t     SectorsPerCluster;
    uint8_t     FATMedia;
} _LUN_ENTRY, *_pLUN_ENTRY;

#define MEDIA_FAT32     0x3
#define MEDIA_FAT16     0x2
#define MEDIA_FAT12     0x1
#define MEDIA_NONE      0x0


uint8_t     fshost_host_startup(_pUSB_FS_HOST);
uint8_t     fshost_enumeration(_pUSB_FS_HOST);
uint8_t     fshost_root_dir(_pUSB_FS_HOST);
uint8_t     fshost_app_identify(_pUSB_FS_HOST, uint8_t *, uint8_t *);
uint8_t     fshost_app_info(_pUSB_FS_HOST, uint32_t *, uint32_t *);
uint32_t    fshost_app_sector(_pUSB_FS_HOST, uint32_t *, uint8_t *);

#endif  //_MSCFS_HOST_H
/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/


