/**********************************************************************************
 *
 * @file    mscfat.h
 * @brief   Head File
 *
 * @date    5 May 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 May 2022      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#ifndef _MSCFAT_H
#define _MSCFAT_H

#pragma pack(1)

//Define Constant
#define SIGNATUREID     0xAA55          //Signature ID
#define ENDOFCHAIN16    0xFFF8          //End of Chain
#define BADCLUSTER16    0xFFF7          //Bad Cluster
#define ENDOFCHAIN32    0x0FFFFFF8      //End of Chain
#define BADCLUSTER32    0x0FFFFFF7      //Bad Cluster
#define IDLECLUSTER     0x00000000      //Idle Cluster
#define RESCLUSTER      0x00000001      //Reserved Cluster

#define SFN_EMPTY           0x00        //Empty Entry
#define SFN_E5              0x05        //First Character is 0xE5
#define SFN_DOT             0x2E        //Dot or DotDot
#define SFN_DELETE          0xE5        //File is Deleted

#define SFN_ATTR_ARCHIVE        (1<<5)
#define SFN_ATTR_SUBDIR         (1<<4)
#define SFN_ATTR_VOLUME         (1<<3)
#define SFN_ATTR_SYSTEM         (1<<2)
#define SFN_ATTR_HIDDEN         (1<<1)
#define SFN_ATTR_READONLY       (1<<0)
#define SFN_ATTR_LFN            (0xF)

#define FAT_SECTOR_SZ       0x200

//Define LUN Structure
typedef struct  _PARTITION_ENTRY_
{
    uint8_t     BootID;                     //Boot ID
    uint8_t     FirstHead;                  //First Head
    uint8_t     FirstSector;                //First Sector
    uint8_t     FirstCylinder;              //First Cylinder
    uint8_t     PartitionID;                //Partition ID
    uint8_t     LastHead;                   //Last Head
    uint8_t     LastSector;                 //Last Sector
    uint8_t     LastCylinder;               //Last Cylinder
    uint32_t    FirstLBA;                   //First LBA
    uint32_t    NumSectors;                 //Number of Sectors
} _PARTITION_ENTRY, *_pPARTITION_ENTRY;

typedef struct  _MBR_ENTRY_
{
    uint8_t BootStrap[0x1be];               //0x000~0x1bb, BootStrap Data
    _PARTITION_ENTRY    Partition0;         //0x1be~0x1cb, Partition Entry 0
    _PARTITION_ENTRY    Partition1;         //0x1ce~0x1db, Partition Entry 1
    _PARTITION_ENTRY    Partition2;         //0x1de~0x1eb, Partition Entry 2
    _PARTITION_ENTRY    Partition3;         //0x1ee~0x1fb, Partition Entry 3
    uint16_t            Signature;          //0x1fe~0x1ff, Signature
} _MBR_ENTRY, *_pMBR_ENTRY;

typedef struct  _BPB_EXT16_
{
    uint8_t     DriveNumber;                //0x024, Logical Drive Number of Partition
    uint8_t     Reserved1;                  //0x025, Reserved
    uint8_t     ExtendedSignature;          //0x026, Extended Sugnature
    uint32_t    SerialNumber;               //0x027~0x02a, Serial Number of Partition
    uint8_t     VolumeName[11];             //0x02b~0x035, Volume Name of Partition
    uint8_t     FATName[8];                 //0x036~0x03d, FAT32 Name
    uint8_t     ExecCode[448];              //0x03e~0x1fd, Executable Code
} _BPB_EXT16, *_pBPB_EXT16;

typedef struct  _BPB_EXT32_
{
    uint32_t    SectorsPreFAT32;            //0x024~0x027, Logical Sectors Per FAT32
    uint16_t    FATFlag;                    //0x028~0x029, FAT Flag
    uint16_t    FATVersion;                 //0x02a~0x02b, FAT Version
    uint32_t    RootCluster;                //0x02c~0x02f, Cluster of Root
    uint16_t    FSInfoSector;               //0x030~0x031, Sector Number of File System Information
    uint16_t    BackupBootSector;           //0x032~0x033, Sector Number of Backup Boot
    uint8_t     Reserved0[12];              //0x034~0x03f, Reserved
    uint8_t     DriveNumber;                //0x040, Logical Drive Number of Partition
    uint8_t     Reserved1;                  //0x041, Reserved
    uint8_t     ExtendedSignature;          //0x042, Extended Sugnature
    uint32_t    SerialNumber;               //0x043!0x046, Serial Number of Partition
    uint8_t     VolumeName[11];             //0x047~0x051, Volume Name of Partition
    uint8_t     FATName[8];                 //0x052~0x059, FAT32 Name
    uint8_t     ExecCode[420];              //0x05a~0x1fd, Executable Code
} _BPB_EXT32, *_pBPB_EXT32;

typedef struct  _BPB_ENTRY_
{
    uint8_t     JumpCode[3];                //0x000~0x002, Jump Code + NOP
    uint8_t     OEMName[8];                 //0x003~0x00a, OEM Name
    uint16_t    BytesPerSector;             //0x00b~0x00c, Bytes Per Sector
    uint8_t     SectorsPerCluster;          //0x00d, Sectors Per Cluster
    uint16_t    ReservedSectors;            //0x00e~0x00f, Reserved Sectors
    uint8_t     NumFATs;                    //0x010, Number of FAT
    uint16_t    RootEntry16;                //0x011~0x012, Maxinum Number of FAT12/16 Root Entries
    uint16_t    TotalSectors16;             //0x013~0x014, FAT16 Total Logical Sectors
    uint8_t     MediaID;                    //0x015, Media ID
    uint16_t    SectorsPreFAT16;            //0x016~0x017, Logical Sectors Per FAT16
    uint16_t    SectorsPerTrack;            //0x018~0x019, Sectors Per Track
    uint16_t    NumHeads;                   //0x01a~0x01b, Number of Heads
    uint32_t    HiddenSectors;              //0x01c~0x01f, Number of Hidden Sectors
    uint32_t    TotalSectors32;             //0x020~0x023, Number of Sectors
    union
    {
        _BPB_EXT16  Ext16;
        _BPB_EXT32  Ext32;
    } Ext;
    uint16_t    Signature;                  //0x1fe~0x1ff, Signature
} _BPB_ENTRY, *_pBPB_ENTRY;

typedef struct  _SHORT_FILENAME_
{
    uint8_t     Name[8];                    //0x00~0x07, File Name
    uint8_t     Extension[3];               //0x08~0x0a, Extension Name
    uint8_t     Attribute;                  //0x0b, Attribute
    uint8_t     Res0;                       //0x0c, Reserved for NT
    uint8_t     CreatemS;                   //0x0d, Create Time, mS
    uint16_t    CreateTime;                 //0x0e~0x0f, Create Time
    uint16_t    CreateDate;                 //0x10~0x11, Create Date
    uint16_t    LastAccessDate;             //0x12~0x13, Last Access Date
    uint16_t    FirstCluster32;             //0x14~0x15, First Cluster 3~2
    uint16_t    ModifiedTime;               //0x16~0x17, Last Modified Time
    uint16_t    ModifiedDate;               //0x18~0x19, Last Modified Date
    uint16_t    FirstCluster16;             //0x1a~0x1b, First Cluster 1~0
    uint32_t    Size;                       //0x1c~0x1f, File Size
} _SHORT_FILENAME, *_pSHORT_FILENAME;

typedef struct  _LONG_FILENAME_
{
    uint8_t     Ordinal;                    //0x00, Ordinal Field
    uint16_t    UniCode0[5];                //0x01~0x0a, UniCode 0~4
    uint8_t     Attribute;                  //0x0b, Attribute
    uint8_t     Type;                       //0x0c, Type
    uint8_t     CheckSum;                   //0x0d, CheckSum
    uint16_t    UniCode1[6];                //0x0e~0x19, UniCode 5~10
    uint16_t    Cluster;                    //0x1a~0x1b, Cluster
    uint16_t    UniCode2[2];                //0x1c~0x1f, UniCode 11~12
} _LONG_FILENAME, *_pLONG_FILENAME;

#endif  //_MSCFAT_H
/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/


