/**********************************************************************************
 *
 * @file    app_printer_desc.c
 * @brief   c File
 *
 * @date    5 May 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 May 2022      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#include "es32f0283.h"
#include "usb_core.h"
#include "usb_enum.h"
#include "usb_dev_enum.h"
#include "usbprinter.h"
#include "app_printer_desc.h"
#include <stdio.h>

#pragma pack(1)

/****
    * @brief    PRINTER Device Descriptor Data
****/
const   _USB_DEVICE_DESC    PrinterDeviceDesc =
{
    sizeof(_USB_DEVICE_DESC),   //Length=0x12
    USB_DTYPE_DEVICE,           //Type=1
    0x0200,                     //USB 2.00
    USB_CLASS_PRINTER,          //Class
    USB_SUBCLASS_UNDEFINED,     //Sub Class
    USB_PROTOCOL_UNDEFINED,     //Protocol
    USBD_CTRL_PKTSZ,            //EP0 packet size=64
    VID_ESSEMI,                 //VID=0x30cc
    PID_PRINTER,                //PID=0xff09,
    0x100,                      //Release Number=1.00
    0x1,                        //iManufactor
    0x2,                        //iProduct=string1
    0,                          //iSerialNumber
    0x1,                        //Number of Configurations
};
/****
    * @brief    PRINTER Configuration Descriptor Data
****/
const   _PRINTER_CONFIGURATION_DESC PrinterConfigurationDesc =
{
//Configuration Descriptor
    sizeof(_USB_CONFIGURATION_DESC),    //Length=9
    USB_DTYPE_CONFIGURATION,            //Type=2
    sizeof(_PRINTER_CONFIGURATION_DESC),    //Total Length
    0x1,                                //Number of Interface
    0x1,                                //Value for SetConfiguration
    0,                                  //String Index
    (USB_CONFIG_ATTR_RESERVED | USB_CONFIG_ATTR_BUS_POWER), //Bus Power, no Remote Wakeup
    USB_CONFIG_MAXPOWER(USB_POWER_LOW), //Maxpower=100mA
//PRINTER Data Interface0
    sizeof(_USB_INTERFACE_DESC),        //Length=9
    USB_DTYPE_INTERFACE,                //Type=4
    PRINTER_INTERFACE_DATA,             //Interface Number
    0,                                  //Alternate Setting
    0x2,                                //Number of Endpoints
    USB_CLASS_PRINTER,                  //PRINTER Data Class
    PRINTER_SUBCLASS_PRINTER,           //Sub Class
    PRINTER_PROTOCOL_BIDIRECTIONAL,     //Protocol
    0x0,                                //String Index
//PRINTER EP1 In Descriptor
    sizeof(_USB_ENDPOINT_DESC),         //Length=7
    USB_DTYPE_ENDPOINT,                 //Type=5
    (USB_EP_ADDR_IN | USBEP1),          //EP1, In
    USB_EP_ATTR_BULK,                   //Bulk
    PRINTER_BULK_PKTSZ,                 //Max Packet Size=64
    0x0,                                //Interval=0ms
//PRINTER EP1 Out Descriptor
    sizeof(_USB_ENDPOINT_DESC),         //Length=7
    USB_DTYPE_ENDPOINT,                 //Type=5
    (USB_EP_ADDR_OUT | USBEP1),         //EP1, Out
    USB_EP_ATTR_BULK,                   //Bulk
    PRINTER_BULK_PKTSZ,                 //Max Packet Size=64
    USB_EP_INTERVAL(0),                 //Interval=0ms
};
/****
    * @brief    PRINTER String 0 Descriptor Data
****/
const   _USB_STRING_0_DESC  PrinterString0Desc =
{
    sizeof(_USB_STRING_0_DESC),         //Length=4
    USB_DTYPE_STRING,                   //Type=3
    0x0409,                             //Language ID
};
/****
    * @brief    PRINTER String 1 Descriptor Data
****/
const   _USB_STRING_1_DESC  PrinterString1Desc =
{
    sizeof(_USB_STRING_1_DESC),         //Length
    USB_DTYPE_STRING,                   //Type=3
    {
        'E', 'a', 's', 't', 'S', 'o', 'f', 't',
    },                                  //String Data
};
/****
    * @brief    PRINTER String 2 Descriptor Data
****/
const   _USB_STRING_2_DESC  PrinterString2Desc =
{
    sizeof(_USB_STRING_2_DESC),         //Length
    USB_DTYPE_STRING,                   //Type=3
    {
        'U', 'S', 'B', ' ', 'P', 'r', 'i', 'n', 't', 'e', 'r',
    },                                  //String Data
};

/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/
