/**********************************************************************************
 *
 * @file    app_mscbldr_desc.c
 * @brief   c File
 *
 * @date    5 May 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 May 2022      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#include "es32f0283.h"
#include "usb_core.h"
#include "usb_enum.h"
#include "usb_dev_enum.h"
#include "usbmsc.h"
#include "app_mscbldr_desc.h"
#include <stdio.h>

#pragma pack(1)

/****
    * @brief    MSC Device Descriptor Data
****/
const   _USB_DEVICE_DESC    MSCDeviceDesc =
{
    sizeof(_USB_DEVICE_DESC),   //Length=0x12
    USB_DTYPE_DEVICE,           //Type=1
    0x0200,                     //USB 2.00
    0x0,                        //Class=0x00
    0x0,                        //Subclass=0x00
    0x0,                        //Protocol=0x00
    USBD_CTRL_PKTSZ,            //CTRL packet size=64
    VID_ESSEMI,                 //VID=0x30cc
    PID_MSCBLDR,                //PID=0xff06,
    0x100,                      //Release number=1.00
    0x1,                        //iManufactor
    0x2,                        //iProduct=String1
    0x0,                        //iSerialNumber
    0x1,                        //Number of Configurations=0x1
};
/****
    * @brief    MSC Configuration Descriptor Data
****/
const   _MSC_CONFIGURATION_DESC MSCConfigurationDesc =
{
//Configuration Descriptor
    sizeof(_USB_CONFIGURATION_DESC),    //Length=9
    USB_DTYPE_CONFIGURATION,            //Type=2
    sizeof(_MSC_CONFIGURATION_DESC),    //Total Length
    0x1,                            //Number of Interface=0x1
    0x1,                            //Value for SetConfiguration
    0x0,                            //String Index
    0x80,                           //Bus Power, no Remote Wakeup
    0x32,                           //Maxpower=100mA
//MSD Interface
    sizeof(_USB_INTERFACE_DESC),    //Length=9
    USB_DTYPE_INTERFACE,            //Type=4
    0x0,                            //Interface Number
    0x0,                            //Alternate Setting
    0x2,                            //Number of Endpoints
    USB_CLASS_MASS_STORAGE,         //MSC Class
    MSC_SUBCLASS_SCSI,              //Subclass=0x6, SCSI
    0x50,                           //Protocol=0x50, Bulk Only
    0x0,                            //String Index
//MSD EP1 In
    sizeof(_USB_ENDPOINT_DESC),     //Length=7
    USB_DTYPE_ENDPOINT,             //Type=5
    (USB_EP_ADDR_IN | MSC_BULK_IN_EP),  //EP1, In
    USB_EP_ATTR_BULK,               //Bulk
    BLDR_BULK_PKTSZ,                //Max Packet Size=64
    0x0,                            //Interval
//MSD EP1 Out
    sizeof(_USB_ENDPOINT_DESC),     //Length=7
    USB_DTYPE_ENDPOINT,             //Type=5
    (USB_EP_ADDR_OUT | MSC_BULK_OUT_EP),    //EP1, Out
    USB_EP_ATTR_BULK,               //Bulk
    BLDR_BULK_PKTSZ,                //Max Packet Size=64
    0x0,                            //Interval
};
/****
    * @brief    MSC String 0 Descriptor Data
****/
const   _USB_STRING_0_DESC  MSCString0Desc =
{
    sizeof(_USB_STRING_0_DESC),     //length=4
    USB_DTYPE_STRING,               //Type=3
    0x0409,                         //Language ID
};
/****
    * @brief    MSC String 1 Descriptor Data
****/
const   _USB_STRING_1_DESC  MSCString1Desc =
{
    sizeof(_USB_STRING_1_DESC),     //length
    USB_DTYPE_STRING,               //type=3
    {
        'E', 'a', 's', 't', 'S', 'o', 'f', 't',
    },                              //string data
};
/****
    * @brief    MSC String 2 Descriptor Data
****/
const   _USB_STRING_2_DESC  MSCString2Desc =
{
    sizeof(_USB_STRING_2_DESC),     //length
    USB_DTYPE_STRING,               //type=3
    {
        'M', 'S', 'C', ' ', 'F', 'A', 'T', '1', '6',
    },                              //string data
};
/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/
