/**********************************************************************************
 *
 * @file    mscfs_dev.h
 * @brief   Head File
 *
 * @date    5 May 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 May 2022      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#ifndef _MSCFS_DEV_H
#define _MSCFS_DEV_H

/* Public Functions -----------------------------------------------------------*/
#define FLAG_UPDATE_STATUS      1
/* Public Typedef -------------------------------------------------------------*/
typedef enum
{
    BOOT_STATE_READY,
    BOOT_STATE_START,
    BOOT_STATE_SUCCESS,
    BOOT_STATE_FLASH_ERROR,
    BOOT_STATE_IDENTIFY,
} eMSCBootState;

extern  uint32_t    MSCIAPStart;
extern  uint8_t     MSCIAPDone;

uint8_t mscfs_dev_read_lba(uint32_t, uint32_t *);
uint8_t mscfs_dev_write_lba(uint32_t, uint32_t *);

#endif  //_MSCFS_DEV_H
/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/


