/**********************************************************************************
 *
 * @file    fat16_bldr.h
 * @brief   Head File
 *
 * @date    5 May 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 May 2022      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#ifndef _FAT16_BLDR_H
#define _FAT16_BLDR_H

/* Public Macros --------------------------------------------------------------*/
#define BPB_BYTES_PER_SECTOR                (512)
#define BPB_NUMBER_OF_SECTORS               (64 * 1024 * 1024 / BPB_BYTES_PER_SECTOR)
#define BPB_SECTORS_PER_CLUSTER             (2)
#define BPB_RESERVED_SECTORS                (2)
#define BPB_NUMBER_OF_FAT                   (2)
#define BPB_SECTORS_PER_FAT                 (255)
#define BPB_NUMBER_OF_ROOT_ENTRY            (512)

#define DBR_SECTOR                          (0)
#define FAT16_FAT0_SECTOR                   (DBR_SECTOR + BPB_RESERVED_SECTORS)
#define FAT16_FAT1_SECTOR                   (FAT16_FAT0_SECTOR + BPB_SECTORS_PER_FAT)
#define FAT16_ROOT_SECTOR                   (FAT16_FAT1_SECTOR + BPB_SECTORS_PER_FAT)
#define FAT16_DATA_SECTOR                   (FAT16_ROOT_SECTOR + (BPB_NUMBER_OF_ROOT_ENTRY / 16))

#endif  //_FAT16_BLDR_H
/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/
