
#ifndef  _GEN_TYPE_DEF_H
#define  _GEN_TYPE_DEF_H

#define _Retargeting_  0

//----------------data type definition-------------
typedef unsigned char        uCHAR;    // 1 bytes
typedef unsigned short      uSHORT;    // 2 bytes
typedef unsigned long        uLONG;    // 4 bytes
typedef unsigned long long  uDLONG;    // 8 bytes
typedef double              uDOUBLE;    // 8 bytes
//
typedef signed char        CHAR;      //  1 bytes
typedef signed short      SHORT;    //  2 bytes
typedef signed long        LONG;      //  4 bytes
typedef signed long long  DLONG;    //   8 bytes
//
typedef float            FLOAT;    // 4 bytes
typedef double          DOUBLE;    // 8 bytes
typedef long double      LDOUBLE;    // 12 bytes

typedef double              F64;
typedef float                F32; // float
typedef unsigned long       U40;
typedef unsigned int        U32;
typedef unsigned short      U16;
typedef unsigned long long  U64;

typedef unsigned char      U8;

typedef long long        I64;
typedef long            I40;
typedef int              I32;
typedef short            I16;
typedef char            I8;
typedef char            C8;
typedef short            S16;
typedef int              S32;


//----------------end data type definition--------
//-----------------enum  type  definition---------
//typedef  enum{FALSE = 0,TRUE = 1} BOOL;
typedef enum {enum0 = 0, enum1 = 1, enum2 = 2, enum3 = 3, enum4 = 4} T_ENUM;
//-----------------end enum  type  definition-----

/******************************************************************************
  Description: 
******************************************************************************/
#define NULL  0

#define HI    1
#define HIGH  1
#define LOW    0
//-------------------------------------------------
#define OFF    0
#define ON    1
#define AUTO  2
//-------------------------------------------------
//#define ENABLE    1
//#define DISABLE  0
#define NONE    0
//-------------------------------------------------
//#define FAIL    1   //ERROR
//#define SUCCESS  0   //PASS
//-------------------------------------------------
//#define FALSE    0
//#define TRUE    1
//-------------------------------------------------
#define DIR_RIGHT  0
#define DIR_LEFT  1
//-------------------------------------------------
#define PLUS_SIGN    1
#define MINUS_SIGN  2
//-------------------------------------------------
#define NO    0
#define YES    1
//-------------------------------------------------

//------------------struct type definiton---------
typedef struct
{
    U8  bit0   : 1;
    U8  bit1   : 1;
    U8  bit2   : 1;
    U8  bit3   : 1;
    U8  bit4   : 1;
    U8  bit5   : 1;
    U8  bit6   : 1;
    U8  bit7   : 1;

} T_STRUCT;
//------------------end struct type definiton------
//------------------union type definiton-----------
typedef union
{
    U32  dword;
    //
    struct
    {
        U16 word0;
        U16 word1;
    } word;
    //
    struct
    {
        U8  byte0;
        U8  byte1;
        U8  byte2;
        U8  byte3;
    } byte;
    //
    struct
    {
        U8 bit0  : 1;
        U8 bit1  : 1;
        U8 bit2  : 1;
        U8 bit3  : 1;
        U8 bit4  : 1;
        U8 bit5  : 1;
        U8 bit6  : 1;
        U8 bit7  : 1;
        //
        U8 bit8  : 1;
        U8 bit9  : 1;
        U8 bit10  : 1;
        U8 bit11  : 1;
        U8 bit12  : 1;
        U8 bit13  : 1;
        U8 bit14  : 1;
        U8 bit15  : 1;
        //
        U8 bit16  : 1;
        U8 bit17  : 1;
        U8 bit18  : 1;
        U8 bit19  : 1;
        U8 bit20  : 1;
        U8 bit21  : 1;
        U8 bit22  : 1;
        U8 bit23  : 1;
        //
        U8 bit24  : 1;
        U8 bit25  : 1;
        U8 bit26  : 1;
        U8 bit27  : 1;
        U8 bit28  : 1;
        U8 bit29  : 1;
        U8 bit30  : 1;
        U8 bit31  : 1;
    } bit;

} T_UNION;

typedef union
{
    U32  u32;
    //
    struct
    {
        U16 Da[2];
    } u16;
    //
    struct
    {
        U8  Da[4];  //0:Low byte
    } u8;
} U32_UNION;

typedef union
{
    U16  u16;
    //
    struct
    {
        U8  Da[2];  //0:Low byte
    } u8;
} U16_UNION;
//------------------end union type definiton--------

//-------------------------------------------------
#define SBIT0  (1<<0)
#define SBIT1  (1<<1)
#define SBIT2  (1<<2)
#define SBIT3  (1<<3)
#define SBIT4  (1<<4)
#define SBIT5  (1<<5)
#define SBIT6  (1<<6)
#define SBIT7  (1<<7)
#define SBIT8  (1<<8)
#define SBIT9  (1<<9)
#define SBIT10  (1<<10)
#define SBIT11  (1<<11)
#define SBIT12  (1<<12)
#define SBIT13  (1<<13)
#define SBIT14  (1<<14)
#define SBIT15  (1<<15)
#define SBIT16  (1UL<<16)
#define SBIT17  (1UL<<17)
#define SBIT18  (1UL<<18)
#define SBIT19  (1UL<<19)
#define SBIT20  (1UL<<20)
#define SBIT21  (1UL<<21)
#define SBIT22  (1UL<<22)
#define SBIT23  (1UL<<23)
#define SBIT24  (1UL<<24)
#define SBIT25  (1UL<<25)
#define SBIT26  (1UL<<26)
#define SBIT27  (1UL<<27)
#define SBIT28  (1UL<<28)
#define SBIT29  (1UL<<29)
#define SBIT30  (1UL<<30)
#define SBIT31  (1UL<<31)

//*********************************************************
//     ---- Please add your type definition here----
//*********************************************************

















#endif //_GEN_TYPE_DEF_H





