/**********************************************************************************
 *
 * @file    app_hidenum_desc.h
 * @brief   Head File
 *
 * @date    5 May 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 May 2022      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#ifndef _APP_HIDENUM_DESC_H
#define _APP_HIDENUM_DESC_H

#define VID_ESSEMI  0x30CC
#define PID_HIDENUM 0xFF05

#define HID_INT_PKTSZ       16

//*****************************************************************************
//
//! This structure describes the USB string descriptor for all string indexes
//! other than 0 as defined in USB 2.0 specification section 9.6.7.
//
//*****************************************************************************
typedef struct _USB_STRING_1_DESC_
{
    //
    //! The length of this descriptor in bytes.  This value will be 2 greater
    //! than the number of bytes comprising the UNICODE string that the
    //! descriptor contains.
    //
    uint8_t       bLength;

    //
    //! The type of the descriptor.  For a string descriptor, this will be
    //! USB_DTYPE_STRING (3).
    //
    uint8_t       bDescriptorType;

    //
    //! The first byte of the UNICODE string.  This string is not NULL
    //! terminated.  Its length (in bytes) can be computed by subtracting 2
    //! from the value in the bLength field.
    //
    uint16_t      bString[8];
} _USB_STRING_1_DESC, *_pUSB_STRING_1_DESC;

//*****************************************************************************
//
//! This structure describes the USB string descriptor for all string indexes
//! other than 0 as defined in USB 2.0 specification section 9.6.7.
//
//*****************************************************************************
typedef struct _USB_STRING_2_DESC_
{
    //
    //! The length of this descriptor in bytes.  This value will be 2 greater
    //! than the number of bytes comprising the UNICODE string that the
    //! descriptor contains.
    //
    uint8_t       bLength;

    //
    //! The type of the descriptor.  For a string descriptor, this will be
    //! USB_DTYPE_STRING (3).
    //
    uint8_t       bDescriptorType;

    //
    //! The first byte of the UNICODE string.  This string is not NULL
    //! terminated.  Its length (in bytes) can be computed by subtracting 2
    //! from the value in the bLength field.
    //
    uint16_t      bString[10];
} _USB_STRING_2_DESC, *_pUSB_STRING_2_DESC;

typedef struct  _HID_CONFIGURATION_DESC_        //HID Configuration
{
    _USB_CONFIGURATION_DESC     ConfigutationDesc;
    _USB_INTERFACE_DESC         InterfaceDesc;
    _HID_HID_DESC               HIDDesc;
    _USB_ENDPOINT_DESC          EP1InDesc;
    _USB_ENDPOINT_DESC          EP1OutDesc;
} _HID_CONFIGURATION_DESC, *_pHID_CONFIGURATION_DESC;

//endpoint define
#define EP_CTRLIN       0
#define EP_CTRLOUT      0
#define EP_INTIN        1
#define EP_INTOUT       1

extern  const   _USB_DEVICE_DESC    HIDDeviceDesc;
extern  const   _HID_CONFIGURATION_DESC HIDConfigurationDesc;
extern  const   uint8_t HIDReportDesc[];
extern  const   _USB_STRING_0_DESC  HIDString0Desc;
extern  const   _USB_STRING_1_DESC  HIDString1Desc;
extern  const   _USB_STRING_2_DESC  HIDString2Desc;

#endif  //_APP_HIDENUM_DESC_H

/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/
