/**********************************************************************************
 *
 * @file    app_hidbldr_desc.c
 * @brief   c File
 *
 * @date    5 May 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 May 2022      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#include "es32f0283.h"
#include "usb_core.h"
#include "usb_enum.h"
#include "usb_dev_enum.h"
#include "usbhid.h"
#include "app_hidbldr_desc.h"
#include <stdio.h>

#pragma pack(1)

/****
    * @brief    HID Report Descriptor Data
****/
const   uint8_t BLDRReportDesc[] =
{
//EBD Control
    0x06, 0xf8, 0xff,       //Usage Page (Vendor)
    0x09, 0x80,             //  Usage (ISP_Control)
    0xa1, 0x01,             //Collection (Application)

    0x15, 0x00,             //  Logical Minimum (0)
    0x26, 0xff, 0x00,       //  Logical Maximum (255)
    0x75, 0x08,             //  Report Size (8)
    0x95, 0x40,             //  Report Count (64)

//BLDR Write Bulk
    0x09, 0x02,             //  Usage (2)
    0x91, 0x02,             //  Output (Absolute, Variable, Data)
//BLDR Read Bulk
    0x09, 0x03,             //  Usage (3)
    0x81, 0x02,             //  Input (Absolute, Variable, Data)

    0xc0,                   //End Collection (Application)
};
/****
    * @brief    HID Device Descriptor Data
****/
const   _USB_DEVICE_DESC    BLDRDeviceDesc =
{
    sizeof(_USB_DEVICE_DESC),   //length=0x12
    USB_DTYPE_DEVICE,       //type=1
    0x0200,                 //USB 2.00
    0x0,                    //class
    0x0,                    //sub class
    0x0,                    //protocol
    USBD_CTRL_PKTSZ,        //EP0 packet size=64
    VID_ESSEMI,             //VID=0x30cc
    PID_HIDBLDR,            //PID=0xf000,
    0x100,                  //release number=1.00
    0x1,                    //iManufactor
    0x2,                    //iProduct=string1
    0x0,                    //iSerialNumber
    0x1,                    //number of configurations
};
/****
    * @brief    HID Configuration Descriptor Data
****/
const   _HID_CONFIGURATION_DESC BLDRConfigurationDesc =
{
//configuration descriptor
    sizeof(_USB_CONFIGURATION_DESC),    //length=9
    USB_DTYPE_CONFIGURATION,            //type=2
    sizeof(_HID_CONFIGURATION_DESC),    //total length
    0x1,                    //number of interface
    0x1,                    //value for SetConfiguration
    0x0,                    //string index
    0x80,                   //bus power, no remote wakeup
    0x32,                   //maxpower=100mA
//interface descriptor
    sizeof(_USB_INTERFACE_DESC),    //length=9
    USB_DTYPE_INTERFACE,    //type=4
    0x0,                    //interface number
    0x0,                    //alternate setting
    0x2,                    //number of endpoints
    USB_CLASS_HID,          //HID class
    0x0,                    //sub class
    0x0,                    //protocol
    0x0,                    //string index
//HID descriptor
    sizeof(_HID_HID_DESC),  //length=9
    HID_DTYPE_HID,          //type=0x21
    0x0111,                 //bcdHID
    0x00,                   //bCountryCode
    0x01,                   //Number of HID class descriptors
    {
        HID_DTYPE_REPORT,       //Report descriptor type.
        sizeof(BLDRReportDesc),     //Total length of Report descriptor.
    },
//Endpoint1 In Descriptor
    sizeof(_USB_ENDPOINT_DESC), //length=7
    USB_DTYPE_ENDPOINT,     //type=5
    (USB_EP_ADDR_IN | IAP_IN_DATA_EP),  //EP1, In
    USB_EP_ATTR_INT,        //interrupt
    BLDR_INT_PKTSZ,         //max packet size=64
    0x01,                   //interval=1ms
//Endpoint1 Out Descriptor
    sizeof(_USB_ENDPOINT_DESC), //length=7
    USB_DTYPE_ENDPOINT,     //type=5
    (USB_EP_ADDR_OUT | IAP_OUT_DATA_EP),    //EP1, Out
    USB_EP_ATTR_INT,        //interrupt
    BLDR_INT_PKTSZ,         //max packet size=64
    0x01,                   //interval=1ms
};
/****
    * @brief    HID String 0 Descriptor Data
****/
const   _USB_STRING_0_DESC  BLDRString0Desc =
{
    sizeof(_USB_STRING_0_DESC), //length=4
    USB_DTYPE_STRING,           //type=3
    0x0409,                 //language ID
};
/****
    * @brief    HID String 1 Descriptor Data
****/
const   _USB_STRING_1_DESC  BLDRString1Desc =
{
    sizeof(_USB_STRING_1_DESC), //length
    USB_DTYPE_STRING,       //type=3
    {
        'E', 'a', 's', 't', 'S', 'o', 'f', 't',
    },                      //string data
};
/****
    * @brief    HID String 2 Descriptor Data
****/
const   _USB_STRING_2_DESC  BLDRString2Desc =
{
    sizeof(_USB_STRING_2_DESC), //length
    USB_DTYPE_STRING,           //type=3
    {
        'H', 'I', 'D', ' ', 'B', 'L', 'D', 'R',
    },                      //string data
};
/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/


