/**********************************************************************************
 *
 * @file    iap_update.h
 * @brief   Head File
 *
 * @date    5 May 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 May 2022      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __IAP_UPDATE_H__
#define __IAP_UPDATE_H__
/* Includes -------------------------------------------------------------------*/
/* Public Functions -----------------------------------------------------------*/
/* Public Typedef -------------------------------------------------------------*/
/* Public Macros --------------------------------------------------------------*/
#define EBDDATA_BASE                ((uint32_t)FLASH_BASE)  // EFLASH Main  (64K Bytes)
#define EBDINFO_BASE                ((uint32_t)FLASH_INFO_BASE) // EFLASH Info  (6K Bytes) - Boot Loader Memory 
#define IAP_FLASH_USED              (0x6000)
#if 1
    #define IAP_FLASH_START             (IAP_FLASH_USED)
    #define IAP_FALSH_TOP               (0x00020000U)
    #define IAP_FLASH_PAGE_SIZE         (0x00000200U)
    #define IAP_FLASH_IPAGE_SIZE        (0x00000200U)
    #define IAP_FLASH_SIZE              (IAP_FALSH_TOP - IAP_FLASH_START)
    #define IAP_BLDR_START              (0x00000000U)
#else
    #define IAP_FLASH_START             (0x00000000U)
    #define IAP_FALSH_TOP               (0x00020000U - IAP_FLASH_USED)
    #define IAP_FLASH_PAGE_SIZE         (0x00000200U)
    #define IAP_FLASH_IPAGE_SIZE        (0x00000200U)
    #define IAP_FLASH_SIZE              (IAP_FALSH_TOP - IAP_FLASH_START)
    #define IAP_BLDR_START              (IAP_FALSH_TOP)
#endif

/* Public Constants -----------------------------------------------------------*/
/* Public Variables -----------------------------------------------------------*/
/* Private Macros -------------------------------------------------------------*/
/* Private Constants-----------------------------------------------------------*/
/* Private Functions ----------------------------------------------------------*/
uint8_t iap_bldr_fixed(uint32_t);
uint8_t iap_check_and_run(uint32_t);
uint8_t iap_flash_erase(uint32_t, uint32_t);
uint8_t iap_flash_program(uint32_t, uint32_t, uint32_t *);
uint8_t iap_flash_read(uint32_t, uint32_t, uint32_t *);
void iap_flash_info(uint32_t *, uint32_t *);
#endif      //__IAP_UPDATE_H__
/******************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/

