/**********************************************************************************
 *
 * @file    eslab_parser.h
 * @brief   Head File
 *
 * @date    5 May 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 May 2022      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#ifndef _ESLAB_PARSER_H
#define _ESLAB_PARSER_H

#define ESLAB_CMD_REQUEST       '?'
#define ESLAB_CMD_ACK           '!'
#define ESLAB_CMD_SPACE         ' '
#define ESLAB_CMD_CR            '\r'
#define ESLAB_CMD_LF            '\n'
#define ESLAB_CMD_END           '\0'

#define ESLAB_CMD_WRITE         'W'
#define ESLAB_CMD_SEND          'D'

typedef enum
{
    ESLAB_ACK_OK = 0,
    ESLAB_ACK_CMD_INVALID,
    ESLAB_ACK_PARAM_ERROR,
    ESLAB_ACK_COUNT_ERROR,
    ESLAB_ACK_ADDR_ERROR,
    ESLAB_ACK_BUSY,
    ESLAB_ACK_NEXT_FRAME,
    ESLAB_ACK_CONFIG_FAIL,
    ESLAB_ACK_CHECK_ERROR,
    ESLAB_ACK_SLAVE_NACK,
    ESLAB_ACK_SLAVE_BUSY,
} eESLAB_ResponseCode;

extern  uint32_t    HIDIAPStart;
extern  uint8_t     HIDIAPDone;

uint8_t eslab_command_parser(uint8_t *, uint8_t *);

#endif  //_ESLAB_PARSER_H
/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/
