/**
  **************************************************************************************
  * @file    es32f0283_it.c
  * @brief   ES32F0283_It Source File.
  *
  * @version V0.01
  * @data    4/15/2019
  * @author  Eastsoft AE Team
  * @note
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co., Ltd. ALL rights reserved.
  *
  **************************************************************************************
  */
#define isr_GLOBALS

#include "Interrupt.h"
#include "main.h"

extern  void usb_irq_handler(void);

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup ES32F0283_It
  * @{
  */

/* Includes -------------------------------------------------------------------*/
/* Public Functions -----------------------------------------------------------*/
/* Public Init Structure ------------------------------------------------------*/
/* Public Macros --------------------------------------------------------------*/
/* Public Constants -----------------------------------------------------------*/
/* Private Variables ----------------------------------------------------------*/
/* Private Macros -------------------------------------------------------------*/
/* Private Constants-----------------------------------------------------------*/
/* Private Functions ----------------------------------------------------------*/

/** @addtogroup Exceptions Handlers
  * @{
  */

/******************************************************************/
/*                Core Processor Exceptions Handlers           */
/******************************************************************/
void NMI_Handler(void)
{
}

void HardFault_Handler(void)
{
    while (1);

}

void SVC_Handler(void)
{
}

void PendSV_Handler(void)
{
}

void SysTick_Handler(void)
{
}

/******************************************************************/
/*              External Processor Exceptions Handlers            */
/******************************************************************/
/**
  * @brief USB_IRQHandler.
  * @param none
  * @retval none
  */
void USB_IRQHandler(void)        /*  IRQ 31  */
{
    usbh_irq_handler();
}

/**
  * @brief SUART1_2_IRQHandler.
  * @param none
  * @retval none
  */
void SUART1_SUART2_IRQHandler(void)   /*  IRQ 30  */
{
    while (1);
}

/**
  * @brief UART3_IRQHandler.
  * @param none
  * @retval none
  */
void UART3_AES_IRQHandler(void)      /*  IRQ 29  */
{
    while (1);
}

/**
  * @brief UART2_IRQHandler.
  * @param none
  * @retval none
  */
void UART2_IRQHandler(void)      /*  IRQ 28  */
{
    while (1);
}

/**
  * @brief SUART12_IRQHandler.
  * @param none
  * @retval none
  */
void UART1_IRQHandler(void)      /*  IRQ 27 */
{
    while (1);
}

/**
  * @brief SPI2_IRQHandler.
  * @param none
  * @retval none
  */
void SPI2_IRQHandler(void)      /*  IRQ 26  */
{
    while (1);
}

/**
  * @brief SPI1_IRQHandler.
  * @param none
  * @retval none
  */
void SPI1_IRQHandler(void)      /*  IRQ 25  */
{
    while (1);
}

/**
  * @brief I2C2_IRQHandler.
  * @param none
  * @retval none
  */
void I2C2_IRQHandler(void)      /*  IRQ 24  */
{
    while (1);
}

/**
  * @brief I2C1_IRQHandler.
  * @param none
  * @retval none
  */
void I2C1_IRQHandler(void)      /*  IRQ 23  */
{
    while (1);
}

/**
  * @brief GP16C2T4_IRQHandler.
  * @param none
  * @retval none
  */
void GP16C2T4_IRQHandler(void)   /*  IRQ 22  */
{
    while (1);
}

/**
  * @brief GP16C2T3_IRQHandler.
  * @param none
  * @retval none
  */
void GP16C2T3_IRQHandler(void)   /*  IRQ 21  */
{
    while (1);
}

/**
  * @brief GP16C2T2_IRQHandler.
  * @param none
  * @retval none
  */
void GP16C2T2_IRQHandler(void)   /*  IRQ 31  */
{
    while (1);
}

/**
  * @brief GP16C2T1_IRQHandler.
  * @param none
  * @retval none
  */
void GP16C2T1_IRQHandler(void)   /*  IRQ 19  */
{
    while (1);
}

/**
  * @brief GP16C4T3_IRQHandler.
  * @param none
  * @retval none
  */
void GP16C4T3_IRQHandler(void)   /*  IRQ 18  */
{
    while (1);
}

/**
  * @brief GP16C4T2_IRQHandler.
  * @param none
  * @retval none
  */
void GP16C4T2_IRQHandler(void)   /*  IRQ 17  */
{
    while (1);
}

/**
  * @brief GP16C4T1_IRQHandler.
  * @param none
  * @retval none
  */
void GP16C4T1_IRQHandler(void)   /*  IRQ 16  */
{
    while (1);
}

/**
  * @brief GP32C4T1_IRQHandler.
  * @param none
  * @retval none
  */
void GP32C4T1_IRQHandler(void)   /*  IRQ 15  */
{
    while (1);
}

/**
  * @brief BS16T1_IRQHandler.
  * @param none
  * @retval none
  */
void BS16T1_IRQHandler(void)     /*  IRQ 14  */
{
    while (1);
}

/**
  * @brief AD16C4T1_IRQHandler.
  * @param none
  * @retval none
  */
void AD16C4T1_IRQHandler(void)   /*  IRQ 13  */
{
    while (1);
}

/**
  * @brief ADC_CMP_IRQHandler.
  * @param none
  * @retval none
  */
void ADC_CMP_IRQHandler(void)   /*  IRQ 12  */
{
    while (1);
}

/**
  * @brief DMA1_CH3_5_IRQHandler.
  * @param none
  * @retval none
  */
void DMA1_CH3_5_IRQHandler(void)   /*  IRQ 11  */
{
    while (1);
}

/**
  * @brief DMA1_CH1_2_IRQHandler.
  * @param none
  * @retval none
  */
void DMA1_CH1_2_IRQHandler(void)    /*  IRQ 10  */
{
    while (1);
}

/**
  * @brief DMA1_CH0_IRQHandler.
  * @param none
  * @retval none
  */
void DMA1_CH0_IRQHandler(void)     /*  IRQ 9  */
{
    while (1);
}

/**
  * @brief EXTI4_15_IRQHandler.
  * @param none
  * @retval none
  */
void EXTI4_15_IRQHandler(void)     /*  IRQ 7  */
{
    while (1);
}

/**
  * @brief EXTI2_3_IRQHandler.
  * @param none
  * @retval none
  */
void EXTI2_3_IRQHandler(void)      /*  IRQ 6  */
{
    while (1);
}

/**
  * @brief EXTI0_1_IRQHandler.
  * @param none
  * @retval none
  */
void EXTI0_1_IRQHandler(void)      /*  IRQ 5  */
{
    while (1);
}

/**
  * @brief WAKEUP_IRQHandler.
  * @param none
  * @retval none
  */
//------------------------------------ IRQ 3
void LowPowerWakeup_IRQHandler(void)       /*  IRQ 3   */
{
    while (1);
}

/**
  * @brief RTC_IRQHandler.
  * @param none
  * @retval none
  */
void RTC_IRQHandler(void)          /*  IRQ 2  */
{
    while (1);
}

/**
  * @brief PVD_IRQHandler.
  * @param none
  * @retval none
  */
void PVD_IRQHandler(void)          /*  IRQ 1  */
{
    while (1);
}

/**
  * @brief WWDG_IRQHandler.
  * @param none
  * @retval none
  */
void WWDT_IRQHandler(void)           /*  IRQ 0  */
{
    while (1);
}

/**
  * @} Exceptions Handlers
  */

/**
  * @} ES32F0283_It
  */

/**
  * @} Projects_Examples_MD
  */
/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF ES32F0283_It.C****/
