/**********************************************************************************
 *
 * @file    app_dual_cdc_desc.c
 * @brief   c File
 *
 * @date    5 May 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 May 2022      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#include "es32f0283.h"
#include "usb_core.h"
#include "usb_enum.h"
#include "usb_dev_enum.h"
#include "usbcdc.h"
#include "app_dual_cdc_desc.h"
#include <stdio.h>

#pragma pack(1)

/****
    * @brief    CDC Device Descriptor Data
****/
const   _USB_DEVICE_DESC    CDCDeviceDesc =
{
    sizeof(_USB_DEVICE_DESC),   //Length=0x12
    USB_DTYPE_DEVICE,           //Type=1
    0x0200,                     //USB 2.00
    USB_CLASS_MISC,             //Class,0xEF=MISC
    MISC_SUBCLASS_COMMON,       //Sub Class, 0x02=COMM
    MISC_PROTOCOL_IAD,          //Protocol, 0x01=IAD
    USBD_CTRL_PKTSZ,            //EP0 packet size=64
    VID_ESSEMI,                 //VID=0x30cc
    PID_DUAL_CDC,               //PID=0xff08,
    0x100,                      //Release Number=1.00
    0x1,                        //iManufactor
    0x2,                        //iProduct=string1
    0,                          //iSerialNumber
    0x1,                        //Number of Configurations
};
/****
    * @brief    CDC Configuration Descriptor Data
****/
const   _CDC_CONFIGURATION_DESC CDCConfigurationDesc =
{
//Configuration Descriptor
    sizeof(_USB_CONFIGURATION_DESC),    //Length=9
    USB_DTYPE_CONFIGURATION,            //Type=2
    sizeof(_CDC_CONFIGURATION_DESC),    //Total Length
    0x4,                                //Number of Interface
    0x1,                                //Value for SetConfiguration
    0,                                  //String Index
    (USB_CONFIG_ATTR_RESERVED | USB_CONFIG_ATTR_BUS_POWER), //Bus Power, no Remote Wakeup
    USB_CONFIG_MAXPOWER(USB_POWER_LOW), //Maxpower=100mA
//CDC1 IAD
    sizeof(_USB_INTERFACE_ASSOCIATION_DESC),    //length=8
    USB_DTYPE_IAD,                      //type=0xb
    CDC1_INTERFACE_COMM,                //First Interface
    0x2,                                //Interface Count
    USB_CLASS_CDC,                      //Class=2, CDC
    CDC_SUBCLASS_ABSTRACT_CONTROL,      //Sub Class=2, Abstract
    CDC_CI_PROTOCOL_ITU_T_V250,         //Protocol=1, AT Command V.250
    0,                                  //iFunction
//CDC1 Control Interface0
    sizeof(_USB_INTERFACE_DESC),        //Length=9
    USB_DTYPE_INTERFACE,                //Type=4
    CDC1_INTERFACE_COMM,                //Interface Number
    0,                                  //Alternate Setting
    0x1,                                //Number of Endpoints
    USB_CLASS_CDC,                      //Class=2, CDC
    CDC_SUBCLASS_ABSTRACT_CONTROL,      //Sub Class=2, Abstract
    CDC_CI_PROTOCOL_ITU_T_V250,         //Protocol=1, AT Command V.250
    0x0,                                //String Index
//CDC1 Header Functional Descriptor
    sizeof(_CDC_HEADER_DESC),           //Length=5
    CDC_CS_INTERAFCE,                   //Type=0x24, CS_INTERFACE
    CDC_FD_SUBTYPE_HEADER,              //Subtype=0x0, Header
    0110,                               //bcdCDC
//CDC1 Abstract Functional Descriptor
    sizeof(_CDC_ABSTRACT_DESC),         //Length=4
    CDC_CS_INTERAFCE,                   //Type=0x24, CS_INTERFACE
    CDC_FD_SUBTYPE_ABSTRACT_CTRL_MGMT,  //Subtype=0x2, Abstract
    (CDC_ACM_SUPPORTS_LINE_PARAMS | CDC_ACM_SUPPORTS_SEND_BREAK),   //bmCapabilities
//CDC1 Union Functional Descriptor
    sizeof(_CDC_UNION_DESC),            //Length=5
    CDC_CS_INTERAFCE,                   //Type=0x24, CS_INTERFACE
    CDC_FD_SUBTYPE_UNION,               //Subtype=0x6, Union
    CDC1_INTERFACE_COMM,                //bControlInterface
    CDC1_INTERFACE_DATA,                //bSubordinateInterface0
//CDC1 Call Management Functional Descriptor
    sizeof(_CDC_CALL_MANAGEMENT_DESC),  //Length=5
    CDC_CS_INTERAFCE,                   //Type=0x24, CS_INTERFACE
    CDC_FD_SUBTYPE_CALL_MGMT,           //Subtype=0x1, Call Management
    CDC_CALL_MGMT_HANDLED,              //bmCapabilities
    CDC1_INTERFACE_DATA,                //bDataInterafce
//CDC1 Control EP1 In Descriptor
    sizeof(_USB_ENDPOINT_DESC),         //Length=7
    USB_DTYPE_ENDPOINT,                 //Type=5
    (USB_EP_ADDR_IN | CDC1_ENDPOINT_COMM),  //EP1, In
    USB_EP_ATTR_INT,                    //Interrupt
    CDC_INT_PKTSZ,                      //Max Packet Size=16
    USB_EP_INTERVAL(32),                //Interval=32ms
//CDC1 Data Interface1
    sizeof(_USB_INTERFACE_DESC),        //Length=9
    USB_DTYPE_INTERFACE,                //Type=4
    CDC1_INTERFACE_DATA,                //Interface Number
    0,                                  //Alternate Setting
    0x2,                                //Number of Endpoints
    USB_CLASS_CDC_DATA,                 //CDC Data Class
    USB_SUBCLASS_UNDEFINED,             //Sub Class
    USB_PROTOCOL_UNDEFINED,             //Protocol
    0x0,                                //String Index
//CDC1 Data EP2 In Descriptor
    sizeof(_USB_ENDPOINT_DESC),         //Length=7
    USB_DTYPE_ENDPOINT,                 //Type=5
    (USB_EP_ADDR_IN | CDC1_ENDPOINT_DATA),  //EP2, In
    USB_EP_ATTR_BULK,                   //Bulk
    CDC_BULK_PKTSZ,                     //Max Packet Size=64
    USB_EP_INTERVAL(0),                 //Interval=0ms
//CDC1 Data EP2 Out Descriptor
    sizeof(_USB_ENDPOINT_DESC),         //Length=7
    USB_DTYPE_ENDPOINT,                 //Type=5
    (USB_EP_ADDR_OUT | CDC1_ENDPOINT_DATA), //EP2, Out
    USB_EP_ATTR_BULK,                   //Bulk
    CDC_BULK_PKTSZ,                     //Max Packet Size=64
    USB_EP_INTERVAL(0),                 //Interval=0ms
//CDC2 IAD
    sizeof(_USB_INTERFACE_ASSOCIATION_DESC),    //length=8
    USB_DTYPE_IAD,                      //type=0xb
    CDC2_INTERFACE_COMM,                //First Interface
    0x2,                                //Interface Count
    USB_CLASS_CDC,                      //Class=2, CDC
    CDC_SUBCLASS_ABSTRACT_CONTROL,      //Sub Class=2, Abstract
    CDC_CI_PROTOCOL_ITU_T_V250,         //Protocol=1, AT Command V.250
    0,                                  //iFunction
//CDC2 Control Interface2
    sizeof(_USB_INTERFACE_DESC),        //Length=9
    USB_DTYPE_INTERFACE,                //Type=4
    CDC2_INTERFACE_COMM,                //Interface Number
    0,                                  //Alternate Setting
    0x1,                                //Number of Endpoints
    USB_CLASS_CDC,                      //Class=2, CDC
    CDC_SUBCLASS_ABSTRACT_CONTROL,      //Sub Class=2, Abstract
    CDC_CI_PROTOCOL_ITU_T_V250,         //Protocol=1, AT Command V.250
    0x0,                                //String Index
//CDC2 Header Functional Descriptor
    sizeof(_CDC_HEADER_DESC),           //Length=5
    CDC_CS_INTERAFCE,                   //Type=0x24, CS_INTERFACE
    CDC_FD_SUBTYPE_HEADER,              //Subtype=0x0, Header
    0110,                               //bcdCDC
//CDC2 Abstract Functional Descriptor
    sizeof(_CDC_ABSTRACT_DESC),         //Length=4
    CDC_CS_INTERAFCE,                   //Type=0x24, CS_INTERFACE
    CDC_FD_SUBTYPE_ABSTRACT_CTRL_MGMT,  //Subtype=0x2, Abstract
    (CDC_ACM_SUPPORTS_LINE_PARAMS | CDC_ACM_SUPPORTS_SEND_BREAK),   //bmCapabilities
//CDC2 Union Functional Descriptor
    sizeof(_CDC_UNION_DESC),            //Length=5
    CDC_CS_INTERAFCE,                   //Type=0x24, CS_INTERFACE
    CDC_FD_SUBTYPE_UNION,               //Subtype=0x6, Union
    CDC2_INTERFACE_COMM,                //bControlInterface
    CDC2_INTERFACE_DATA,                //bSubordinateInterface0
//CDC2 Call Management Functional Descriptor
    sizeof(_CDC_CALL_MANAGEMENT_DESC),  //Length=5
    CDC_CS_INTERAFCE,                   //Type=0x24, CS_INTERFACE
    CDC_FD_SUBTYPE_CALL_MGMT,           //Subtype=0x1, Call Management
    CDC_CALL_MGMT_HANDLED,              //bmCapabilities
    CDC2_INTERFACE_DATA,                //bDataInterafce
//CDC2 Control EP3 In Descriptor
    sizeof(_USB_ENDPOINT_DESC),         //Length=7
    USB_DTYPE_ENDPOINT,                 //Type=5
    (USB_EP_ADDR_IN | CDC2_ENDPOINT_COMM),  //EP3, In
    USB_EP_ATTR_INT,                    //Interrupt
    CDC_INT_PKTSZ,                      //Max Packet Size=16
    USB_EP_INTERVAL(32),                //Interval=32ms
//CDC2 Data Interface3
    sizeof(_USB_INTERFACE_DESC),        //Length=9
    USB_DTYPE_INTERFACE,                //Type=4
    CDC2_INTERFACE_DATA,                //Interface Number
    0,                                  //Alternate Setting
    0x2,                                //Number of Endpoints
    USB_CLASS_CDC_DATA,                 //CDC Data Class
    USB_SUBCLASS_UNDEFINED,             //Sub Class
    USB_PROTOCOL_UNDEFINED,             //Protocol
    0x0,                                //String Index
//CDC2 Data EP4 In Descriptor
    sizeof(_USB_ENDPOINT_DESC),         //Length=7
    USB_DTYPE_ENDPOINT,                 //Type=5
    (USB_EP_ADDR_IN | CDC2_ENDPOINT_DATA),  //EP4, In
    USB_EP_ATTR_BULK,                   //Bulk
    CDC_BULK_PKTSZ,                     //Max Packet Size=64
    USB_EP_INTERVAL(0),                 //Interval=0ms
//CDC2 Data EP4 Out Descriptor
    sizeof(_USB_ENDPOINT_DESC),         //Length=7
    USB_DTYPE_ENDPOINT,                 //Type=5
    (USB_EP_ADDR_OUT | CDC2_ENDPOINT_DATA), //EP4, Out
    USB_EP_ATTR_BULK,                   //Bulk
    CDC_BULK_PKTSZ,                     //Max Packet Size=64
    USB_EP_INTERVAL(0),                 //Interval=0ms
};
/****
    * @brief    CDC String 0 Descriptor Data
****/
const   _USB_STRING_0_DESC  CDCString0Desc =
{
    sizeof(_USB_STRING_0_DESC),         //Length=4
    USB_DTYPE_STRING,                   //Type=3
    0x0409,                             //Language ID
};
/****
    * @brief    CDC String 1 Descriptor Data
****/
const   _USB_STRING_1_DESC  CDCString1Desc =
{
    sizeof(_USB_STRING_1_DESC),         //Length
    USB_DTYPE_STRING,                   //Type=3
    {
        'E', 'a', 's', 't', 'S', 'o', 'f', 't',
    },                                  //String Data
};
/****
    * @brief    CDC String 2 Descriptor Data
****/
const   _USB_STRING_2_DESC  CDCString2Desc =
{
    sizeof(_USB_STRING_2_DESC),         //Length
    USB_DTYPE_STRING,                   //Type=3
    {
        'U', 'S', 'B', ' ', 'C', 'D', 'C', ' ', 'C', 'o', 'm', 'p', 'o', 's', 'i', 't', 'e',
    },                                  //String Data
};

/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/
