/**
  **************************************************************************************
  * @file    MAIN.H
  * @brief   ES32F0283 main head file.
  *
  * @version V0.01
  * @data    11/20/2018
  * @author  Eastsoft AE Team
  * @note
  *
  * Copyright (C) 2018 Shanghai Eastsoft Microelectronics Co., Ltd. ALL rights reserved.
  *
  **************************************************************************************
  */

#ifndef __MAIN_H__
#define __MAIN_H__

#include <stdio.h>
#include <stdint.h>
#include "es32f0283.h"
#include "md_syscfg.h"
#include "md_rcu.h"
#include "md_fc.h"
#include "md_gpio.h"
#include "md_uart.h"
#include "md_tick.h"
#include "md_calc.h"

#ifdef MAIN_GLOBALS
    #define MAIN_EXT
#else
    #define MAIN_EXT extern
#endif

#define START_PAGE              0x2000            // flash page for parameters
#define SYSTEM_CLOCK      48000000            // master clock
#define SYSTEM_CLOCKMHZ    (SYSTEM_CLOCK/1000000)
#define TIMER_PERIOD_1KHZ  (SYSTEM_CLOCK/1000)    // 1khz general purpose interrupt

/* Public Functions -----------------------------------------------------------*/
MAIN_EXT volatile uint32_t TmrSystem;
MAIN_EXT uint8_t gu8DispTital;


#define cal_TimeTick(time,sys_time)  ((time)>(sys_time)?0xffffffff-(time)+1+(sys_time):(sys_time)-(time))  // 10ms Time tick
#define cal_usTick(time,sys_time)    ((time)>(sys_time)?0xffff-(time)+1+(sys_time):(sys_time)-(time))      // 1us Time tick
#define GetSystemTime()              (TmrSystem)

#define CheckTime(time)    cal_TimeTick(time,TmrSystem)
#define UpdateTime(time)  ((time)=TmrSystem)
/* Public Init Structure ------------------------------------------------------*/
/* Public Macros --------------------------------------------------------------*/
/* Public Constants -----------------------------------------------------------*/
/* Private Variables ----------------------------------------------------------*/
/* Private Macros -------------------------------------------------------------*/
/* Private Constants-----------------------------------------------------------*/
/* Private Functions ----------------------------------------------------------*/


#endif
/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF MAIN.H****/

