/**********************************************************************************
 *
 * @file    cdc_ring_ctrl.h
 * @brief   Head File
 *
 * @date    5 May 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 May 2022      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#ifndef _CDC_RING_CTRL_H
#define _CDC_RING_CTRL_H

#pragma pack(1)

typedef struct  _CDC_RING_CONTROL_
{
    uint16_t    RingHead;
    uint16_t    RingTail;
    uint16_t    RingSize;
    uint8_t     *pRingBuf;
} _CDC_RING_CONTROL, *_pCDC_RING_CONTROL;

#define CDC_RING_SIZE   2048

//Functional Declaration
// Initialize or reinitialize a circular buffer
void cdc_ring_init(_pCDC_RING_CONTROL, uint16_t, uint8_t *);

// Push a byte into the circular buffer
void cdc_ring_push(_pCDC_RING_CONTROL, uint8_t);

// Return a byte from the circular buffer
uint8_t cdc_ring_pop(_pCDC_RING_CONTROL);

// Get the number of bytes in the circular buffer
uint16_t cdc_ring_used(_pCDC_RING_CONTROL);

// Get the wrap number of bytes in the circular buffer
uint16_t cdc_ring_wrap(_pCDC_RING_CONTROL);

// Get the number of free spots left in the circular buffer
uint16_t cdc_ring_free(_pCDC_RING_CONTROL);

// Attempt to read size bytes from the buffer. Return the number of bytes read
uint16_t cdc_ring_read(_pCDC_RING_CONTROL, uint16_t, uint8_t *);

// Attempt to write size bytes to the buffer. Return the number of bytes written
uint16_t cdc_ring_write(_pCDC_RING_CONTROL, uint16_t, uint8_t *);

// Attempt to flush buffer.
void cdc_ring_flush(_pCDC_RING_CONTROL);

#endif  //_CDC_RING_CTRL_H

/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/
