/**********************************************************************************
 *
 * @file    app_dev_dual_cdc.h
 * @brief   Head File
 *
 * @date    5 May 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 May 2022      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#ifndef _APP_DEV_DUAL_CDC_H
#define _APP_DEV_DUAL_CDC_H

#pragma pack(1)

//DMA3 CDC1 Rx to CDC1 Tx, M2M
#define DMA3CFG         ((MD_DMA_CHANNEL_CFG_DSTINC_NO_INC << CHANNEL_CFG_DST_INC_POSS) | (MD_DMA_CHANNEL_CFG_DSTDATA_SIZE_BYTE << CHANNEL_CFG_DST_SIZE_POSS) |\
                         (MD_DMA_CHANNEL_CFG_SRCINC_NO_INC << CHANNEL_CFG_SRC_INC_POSS) | (MD_DMA_CHANNEL_CFG_SRCDATA_SIZE_BYTE << CHANNEL_CFG_SRC_SIZE_POSS) |\
                         (MD_DMA_CHANNEL_CFG_RPOWER_SIZE_1 << CHANNEL_CFG_R_POWER_POSS) | (MD_DMA_CHANNEL_CFG_MODE_AUTO << CHANNEL_CFG_CYCLE_CTRL_POSS))

//DMA4 CDC2 Rx to UART2 Tx, M2P
#define DMA4CFG         ((MD_DMA_CHANNEL_CFG_DSTINC_NO_INC << CHANNEL_CFG_DST_INC_POSS) | (MD_DMA_CHANNEL_CFG_DSTDATA_SIZE_BYTE << CHANNEL_CFG_DST_SIZE_POSS) |\
                         (MD_DMA_CHANNEL_CFG_SRCINC_NO_INC << CHANNEL_CFG_SRC_INC_POSS) | (MD_DMA_CHANNEL_CFG_SRCDATA_SIZE_BYTE << CHANNEL_CFG_SRC_SIZE_POSS) |\
                         (MD_DMA_CHANNEL_CFG_RPOWER_SIZE_1 << CHANNEL_CFG_R_POWER_POSS) | (MD_DMA_CHANNEL_CFG_MODE_BASIC << CHANNEL_CFG_CYCLE_CTRL_POSS) )

//DMA5 UART2 Ring to CDC2 Tx, M2M
#define DMA5CFG         ((MD_DMA_CHANNEL_CFG_DSTINC_NO_INC << CHANNEL_CFG_DST_INC_POSS) | (MD_DMA_CHANNEL_CFG_DSTDATA_SIZE_BYTE << CHANNEL_CFG_DST_SIZE_POSS) |\
                         (MD_DMA_CHANNEL_CFG_SRCINC_BYTE << CHANNEL_CFG_SRC_INC_POSS) | (MD_DMA_CHANNEL_CFG_SRCDATA_SIZE_BYTE << CHANNEL_CFG_SRC_SIZE_POSS) |\
                         (MD_DMA_CHANNEL_CFG_RPOWER_SIZE_1 << CHANNEL_CFG_R_POWER_POSS) | (MD_DMA_CHANNEL_CFG_MODE_AUTO << CHANNEL_CFG_CYCLE_CTRL_POSS) )

//Functional Declaration
void        dual_cdc_dev_init(_pUSB_FS_DEVICE);
void        dual_cdc_dev_ep_config(_pUSB_FS_DEVICE);
eUSBDState  dual_cdc_dev_enum(_pUSB_FS_DEVICE, eUSBDState);
eUSBDState  dual_cdc_dev_transaction(_pUSB_FS_DEVICE, eUSBDState);

#endif  //_APP_DEV_DUAL_CDC_H

/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/
