/**********************************************************************************
 *
 * @file    app_composite_desc.h
 * @brief   Head File
 *
 * @date    5 May 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 May 2022      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#ifndef _APP_COMPOSITE_DESC_H
#define _APP_COMPOSITE_DESC_H

#define VID_ESSEMI      0x30CC
#define PID_COMPOSITE   0xFF06

#define CDC_INT_PKTSZ       16
#define CDC_BULK_PKTSZ      64
#define HID_INT_PKTSZ       64

//*****************************************************************************
//
//! This structure describes the USB string descriptor for all string indexes
//! other than 0 as defined in USB 2.0 specification section 9.6.7.
//
//*****************************************************************************
typedef struct _USB_STRING_1_DESC_
{
    //
    //! The length of this descriptor in bytes.  This value will be 2 greater
    //! than the number of bytes comprising the UNICODE string that the
    //! descriptor contains.
    //
    uint8_t     bLength;

    //
    //! The type of the descriptor.  For a string descriptor, this will be
    //! USB_DTYPE_STRING (3).
    //
    uint8_t     bDescriptorType;

    //
    //! The first byte of the UNICODE string.  This string is not NULL
    //! terminated.  Its length (in bytes) can be computed by subtracting 2
    //! from the value in the bLength field.
    //
    uint16_t        bString[8];
} _USB_STRING_1_DESC, *_pUSB_STRING_1_DESC;

//*****************************************************************************
//
//! This structure describes the USB string descriptor for all string indexes
//! other than 0 as defined in USB 2.0 specification section 9.6.7.
//
//*****************************************************************************
typedef struct _USB_STRING_2_DESC_
{
    //
    //! The length of this descriptor in bytes.  This value will be 2 greater
    //! than the number of bytes comprising the UNICODE string that the
    //! descriptor contains.
    //
    uint8_t     bLength;

    //
    //! The type of the descriptor.  For a string descriptor, this will be
    //! USB_DTYPE_STRING (3).
    //
    uint8_t     bDescriptorType;

    //
    //! The first byte of the UNICODE string.  This string is not NULL
    //! terminated.  Its length (in bytes) can be computed by subtracting 2
    //! from the value in the bLength field.
    //
    uint16_t        bString[13];
} _USB_STRING_2_DESC, *_pUSB_STRING_2_DESC;

typedef struct  _COMPOSITE_CONFIGURATION_DESC_      //Composite Configuration
{
    _USB_CONFIGURATION_DESC     ConfigutationDesc;
    _USB_INTERFACE_ASSOCIATION_DESC CDCIADDesc;
    _USB_INTERFACE_DESC         CDCControlInterface0Desc;
    _CDC_HEADER_DESC            CDCHeaderDesc;
    _CDC_ABSTRACT_DESC          CDCAbstractDesc;
    _CDC_UNION_DESC             CDCUnionDesc;
    _CDC_CALL_MANAGEMENT_DESC   CDCCallManagementDesc;
    _USB_ENDPOINT_DESC          CDCEP1InDesc;
    _USB_INTERFACE_DESC         CDCDataInterface1Desc;
    _USB_ENDPOINT_DESC          CDCDataEP2InDesc;
    _USB_ENDPOINT_DESC          CDCDataEP2OutDesc;
    _USB_INTERFACE_DESC         HIDInterface2Desc;
    _HID_HID_DESC               HIDHIDDesc;
    _USB_ENDPOINT_DESC          HIDEP3InDesc;
    _USB_ENDPOINT_DESC          HIDEP3OutDesc;
} _COMPOSITE_CONFIGURATION_DESC, *_pCOMPOSITE_CONFIGURATION_DESC;

#define CDC_INTERFACE_CONTROL   0
#define CDC_INTERFACE_DATA      1
#define HID_INTERFACE           2

#define CDC_CONTROL_EP_IN       USBEP1
#define CDC_DATA_EP_IN          USBEP2
#define CDC_DATA_EP_OUT         USBEP2
#define HID_DATA_EP_IN          USBEP3
#define HID_DATA_EP_OUT         USBEP3

extern  const   _USB_DEVICE_DESC    CompositeDeviceDesc;
extern  const   _COMPOSITE_CONFIGURATION_DESC   CompositeConfigurationDesc;
extern  const   uint8_t             HIDReportDesc[];
extern  const   _USB_STRING_0_DESC  CompositeString0Desc;
extern  const   _USB_STRING_1_DESC  CompositeString1Desc;
extern  const   _USB_STRING_2_DESC  CompositeString2Desc;

#endif  //_APP_COMPOSITE_DESC_H

/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/

