/**********************************************************************************
 *
 * @file    app_cdcenum_desc.c
 * @brief   c File
 *
 * @date    5 May 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 May 2022      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#include "es32f0283.h"
#include "usb_core.h"
#include "usb_enum.h"
#include "usb_dev_enum.h"
#include "usbcdc.h"
#include "app_cdcenum_desc.h"
#include <stdio.h>

#pragma pack(1)

/****
    * @brief    CDC Device Descriptor Data
****/
const   _USB_DEVICE_DESC    CDCDeviceDesc =
{
    sizeof(_USB_DEVICE_DESC),   //Length=0x12
    USB_DTYPE_DEVICE,           //Type=1
    0x0200,                     //USB 2.00
    USB_CLASS_CDC,              //Class
    USB_SUBCLASS_UNDEFINED,     //Sub Class
    USB_PROTOCOL_UNDEFINED,     //Protocol
    USBD_CTRL_PKTSZ,            //EP0 packet size=64
    VID_ESSEMI,                 //VID=0x30cc
    PID_CDCENUM,                //PID=0xff01,
    0x100,                      //Release Number=1.00
    0x1,                        //iManufactor
    0x2,                        //iProduct=string1
    0,                          //iSerialNumber
    0x1,                        //Number of Configurations
};
/****
    * @brief    CDC Configuration Descriptor Data
****/
const   _CDC_CONFIGURATION_DESC CDCConfigurationDesc =
{
//Configuration Descriptor
    sizeof(_USB_CONFIGURATION_DESC),    //Length=9
    USB_DTYPE_CONFIGURATION,            //Type=2
    sizeof(_CDC_CONFIGURATION_DESC),    //Total Length
    0x2,                                //Number of Interface
    0x1,                                //Value for SetConfiguration
    0,                                  //String Index
    (USB_CONFIG_ATTR_RESERVED | USB_CONFIG_ATTR_BUS_POWER), //Bus Power, no Remote Wakeup
    USB_CONFIG_MAXPOWER(USB_POWER_LOW), //Maxpower=100mA
//CDC Interface0
    sizeof(_USB_INTERFACE_DESC),        //Length=9
    USB_DTYPE_INTERFACE,                //Type=4
    CDC_INTERFACE_CONTROL,              //Interface Number
    0,                                  //Alternate Setting
    0x1,                                //Number of Endpoints
    USB_CLASS_CDC,                      //Class=2, CDC
    CDC_SUBCLASS_ABSTRACT_CONTROL,      //Sub Class=2, Abstract
    CDC_CI_PROTOCOL_ITU_T_V250,         //Protocol=1, AT Command V.250
    0x0,                                //String Index
//CDC Header Functional Descriptor
    sizeof(_CDC_HEADER_DESC),           //Length=5
    CDC_CS_INTERAFCE,                   //Type=0x24, CS_INTERFACE
    CDC_FD_SUBTYPE_HEADER,              //Subtype=0x0, Header
    0110,                               //bcdCDC
//CDC Abstract Functional Descriptor
    sizeof(_CDC_ABSTRACT_DESC),         //Length=4
    CDC_CS_INTERAFCE,                   //Type=0x24, CS_INTERFACE
    CDC_FD_SUBTYPE_ABSTRACT_CTRL_MGMT,  //Subtype=0x2, Abstract
    (CDC_ACM_SUPPORTS_LINE_PARAMS | CDC_ACM_SUPPORTS_SEND_BREAK), //bmCapabilities
//CDC Union Functional Descriptor
    sizeof(_CDC_UNION_DESC),            //Length=5
    CDC_CS_INTERAFCE,                   //Type=0x24, CS_INTERFACE
    CDC_FD_SUBTYPE_UNION,               //Subtype=0x6, Union
    CDC_INTERFACE_CONTROL,              //bControlInterface
    CDC_INTERFACE_DATA,                 //bSubordinateInterface0
//CDC Call Management Functional Descriptor
    sizeof(_CDC_CALL_MANAGEMENT_DESC),  //Length=5
    CDC_CS_INTERAFCE,                   //Type=0x24, CS_INTERFACE
    CDC_FD_SUBTYPE_CALL_MGMT,           //Subtype=0x1, Call Management
    CDC_CALL_MGMT_HANDLED,              //bmCapabilities
    CDC_INTERFACE_DATA,                 //bDataInterafce
//CDC EP1 In Descriptor
    sizeof(_USB_ENDPOINT_DESC),         //Length=7
    USB_DTYPE_ENDPOINT,                 //Type=5
    (USB_EP_ADDR_IN | USBEP1),          //EP1, In
    USB_EP_ATTR_INT,                    //Interrupt
    CDC_INT_PKTSZ,                      //Max Packet Size=16
    USB_EP_INTERVAL(32),                //Interval=32ms
//CDC Data Interface1
    sizeof(_USB_INTERFACE_DESC),        //Length=9
    USB_DTYPE_INTERFACE,                //Type=4
    CDC_INTERFACE_DATA,                 //Interface Number
    0,                                  //Alternate Setting
    0x2,                                //Number of Endpoints
    USB_CLASS_CDC_DATA,                 //CDC Data Class
    USB_SUBCLASS_UNDEFINED,             //Sub Class
    USB_PROTOCOL_UNDEFINED,             //Protocol
    0x0,                                //String Index
//CDC EP2 In Descriptor
    sizeof(_USB_ENDPOINT_DESC),         //Length=7
    USB_DTYPE_ENDPOINT,                 //Type=5
    (USB_EP_ADDR_IN | USBEP2),          //EP2, In
    USB_EP_ATTR_BULK,                   //Bulk
    CDC_BULK_PKTSZ,                     //Max Packet Size=64
    0x0,                                //Interval=0ms
//CDC EP2 Out Descriptor
    sizeof(_USB_ENDPOINT_DESC),         //Length=7
    USB_DTYPE_ENDPOINT,                 //Type=5
    (USB_EP_ADDR_OUT | USBEP2),         //EP2, Out
    USB_EP_ATTR_BULK,                   //Bulk
    CDC_BULK_PKTSZ,                     //Max Packet Size=64
    USB_EP_INTERVAL(0),                 //Interval=0ms
};
/****
    * @brief    CDC String 0 Descriptor Data
****/
const   _USB_STRING_0_DESC  CDCString0Desc =
{
    sizeof(_USB_STRING_0_DESC),         //Length=4
    USB_DTYPE_STRING,                   //Type=3
    0x0409,                             //Language ID
};
/****
    * @brief    CDC String 1 Descriptor Data
****/
const   _USB_STRING_1_DESC  CDCString1Desc =
{
    sizeof(_USB_STRING_1_DESC),         //Length
    USB_DTYPE_STRING,                   //Type=3
    {
        'E', 'a', 's', 't', 'S', 'o', 'f', 't',
    },                                  //String Data
};
/****
    * @brief    CDC String 2 Descriptor Data
****/
const   _USB_STRING_2_DESC  CDCString2Desc =
{
    sizeof(_USB_STRING_2_DESC),         //Length
    USB_DTYPE_STRING,                   //Type=3
    {
        'U', 'S', 'B', ' ', 'C', 'D', 'C',
    },                                  //String Data
};

/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/

