/**********************************************************************************
 *
 * @file    .c
 * @brief   Source file
 *
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date               Author          Notes
 *          2023-01-17         liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes-------------------------------------------------------------------*/
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
md_rcu_init_typedef rcu_initStruct =    /**< RCU init structure */
{
    MD_RCU_MPRE_MCO_DIV1,
    MD_RCU_MSW_MCO_DISABLE,
    MD_RCU_PLLSRC_HOSC,//MD_RCU_PLLSRC_HRC48,
    MD_RCU_PLLCLK_72M,
    MD_RCU_PPRE_HCLK_DIV_1,
    MD_RCU_HPRE_SYSCLK_DIV_1,
    MD_RCU_SW_SYSCLK_PLL0,
    (RCU_CON_HRCON | RCU_CON_HOSCON | RCU_CON_PLL0ON | RCU_CON_HRC48ON_MSK),
};

md_uart_init_typedef uart_initStruct =    /**< UART init structure */
{
    MD_UART_BAUDRATE_115200,
    MD_UART_LCON_LSB_FIRST,
    MD_UART_LCON_PS_NONE,
    MD_UART_LCON_STOP_1,
    MD_UART_LCON_DLS_8,
};

/* Private function prototypes ----------------------------------------------- */
void gpio_config(void);

/* Private Function ---------------------------------------------------------- */

/**
  * @brief main.
  * @param none
  * @retval none
  */
int main(void)
{
    __disable_irq();
    md_rcu_pll0_init(RCU, &rcu_initStruct);
    md_rcu_sys_init(RCU, &rcu_initStruct);
    md_rcu_enable_gpioa(RCU);
    md_rcu_enable_gpiob(RCU);
    md_rcu_enable_uart1(RCU);
    md_rcu_enable_spi1(RCU);
    md_rcu_enable_usb(RCU);
    gpio_config();

    NVIC->ICER[0] = 0xFFFFFFFFUL;
    md_tick_init(MD_SYSTICK_CLKSRC_HCLK);

    md_uart_init(UART1, &uart_initStruct);

    __enable_irq();

    printf("\rSystem start...\r\n");
    printf("SystemFrequency = %d\r\n", SystemFrequency_SysClk);

    cdc_acm_hid_winusb_descriptor_init();

    while (1)
    {
        md_delay_1ms(1000);
    }
}

/**
  * @brief  Configure the GPIO.
  * @param  None
  * @retval None
  */
void gpio_config(void)
{
    md_gpio_inittypedef gpiox;
    /* config gpiob pin6 (Tx) */
    gpiox.Pin   = MD_GPIO_PIN_6;
    gpiox.Mode  = MD_GPIO_MODE_FUNCTION;
    gpiox.OutputType = MD_GPIO_OUTPUT_PUSHPULL;
    gpiox.Pull  = MD_GPIO_PULL_FLOATING;
    gpiox.OutDrive = MD_GPIO_DRIVING_8MA;
    gpiox.Function = MD_GPIO_AF2;
    md_gpio_init(GPIOB, &gpiox);
    /* config gpiob pin7 (Rx) */
    gpiox.Pin   = MD_GPIO_PIN_7;
    gpiox.Mode  = MD_GPIO_MODE_FUNCTION;
    gpiox.OutputType = MD_GPIO_OUTPUT_PUSHPULL;
    gpiox.Pull  = MD_GPIO_PULL_UP;
    gpiox.OutDrive = MD_GPIO_DRIVING_8MA;
    gpiox.Function = MD_GPIO_AF2;
    md_gpio_init(GPIOB, &gpiox);
}

void usb_dc_low_level_init(void)
{
    md_rcu_enable_usb(RCU);
    md_mcu_irq_config(USB_IRQn, 3, ENABLE);//USB IRQ
}

/**
  * @brief  Uart sendchar.
  * @param  arg: char to be sent.
  * @retval data to be sent.
  */
uint8_t  sendchar(uint8_t ch)
{
    while (!(UART1->STAT & (UART_STAT_TFEMPTY)));  // Tx FIFO empty

    UART1->TXDATA = ch;            // Sent byte
    return (ch);
}

/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE ****/
