/**********************************************************************************
 *
 * @file    interrupt.c
 * @brief   Interrupt C file
 *
 * @date    23 Nov 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          23 Nov  2021    Ginger          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#define isr_GLOBALS

#include "Interrupt.h"
#include "main.h"

/** @addtogroup Projects_Examples
  * @{
  */

/** @addtogroup INTERRUPT
  * @{
  */

/* Includes -------------------------------------------------------------------*/
/* Public Functions -----------------------------------------------------------*/
/* Public Init Structure ------------------------------------------------------*/
/* Public Macros --------------------------------------------------------------*/
/* Public Constants -----------------------------------------------------------*/
/* Private Variables ----------------------------------------------------------*/
/* Private Macros -------------------------------------------------------------*/
/* Private Constants-----------------------------------------------------------*/
/* Private Functions ----------------------------------------------------------*/

#if defined(ES_USBD_CDC_USE_UART)
uint8_t usb_cdc_uart_rxbuf[ES_USBD_CDC_UART_BUF_SIZE];
uint8_t usb_cdc_data_rxbuf[ES_USBD_CDC_UART_BUF_SIZE];   
uint32_t rxcount_from_uart = 0U; 
uint32_t txcount_to_uart = 0U;                                       
uint32_t rxcount_from_usb = 0U;      
uint32_t txcount_to_usb = 0U;   
#endif /*defined(ES_USBD_CDC_USE_UART)*/

/** @addtogroup Exceptions Handlers
  * @{
  */

/******************************************************************/
/*                Core Processor Exceptions Handlers           */
/******************************************************************/

void NMI_Handler(void)
{
}

void HardFault_Handler(void)
{
    while (1);

}

void SVC_Handler(void)
{
}

void PendSV_Handler(void)
{
}

void SysTick_Handler(void)
{
		md_inc_tick();
}

/******************************************************************/
/*              External Processor Exceptions Handlers            */
/******************************************************************/


//void USB_IRQHandler(void)           /*  IRQ 31  */
//{
//    while (1);
//}


void UART4_KBCU_IRQHandler(void)    /*  IRQ 30  */
{
    while (1);
}

void UART3_AES_IRQHandler(void)     /*  IRQ 29  */
{
    while (1);
}

void UART2_IRQHandler(void)         /*  IRQ 28 */
{
	ald_usb_int_unregister();
    if (md_uart_is_active_flag_tfempty(UART2)){
		if(rxcount_from_usb != txcount_to_uart){
			md_uart_set_send_data8(UART2, usb_cdc_data_rxbuf[ES_GET_USBD_CDC_UART_BUF_GET_INDEX(txcount_to_uart)]);
			txcount_to_uart++;
		}
		else{
			md_uart_disable_it_tfempty(UART2);
		}
        md_uart_clear_it_tfempty(UART2);
    }
    if (md_uart_is_masked_it_rfnempty(UART2)){
		usb_cdc_uart_rxbuf[ES_GET_USBD_CDC_UART_BUF_GET_INDEX(rxcount_from_uart)] = md_uart_get_recv_data8(UART2);
		rxcount_from_uart++;
        md_uart_clear_it_rfnempty(UART2);
    }
	ald_usb_int_register();
    return;
}

void UART1_IRQHandler(void)         /*  IRQ 27 */
{
    while (1);
}

void SPI2_IRQHandler(void)          /*  IRQ 26 */
{
    while (1);
}

void SPI1_IRQHandler(void)          /*  IRQ 25  */
{
    while (1);
}

void I2C2_IRQHandler(void)          /*  IRQ 24  */
{
    while (1);
}

void I2C1_IRQHandler(void)          /*  IRQ 23  */
{
    while (1);
}

void GP16C2T4_IRQHandler(void)      /*  IRQ 22  */
{
    while (1);
}

void GP16C2T3_IRQHandler(void)      /*  IRQ 21  */
{
    while (1);
}

void GP16C2T2_IRQHandler(void)      /*  IRQ 20  */
{
    while (1);
}

void GP16C2T1_IRQHandler(void)      /*  IRQ 19  */
{
    while (1);
}

void GP16C4T3_IRQHandler(void)      /*  IRQ 18  */
{
    while (1);
}

void GP16C4T2_IRQHandler(void)      /*  IRQ 17  */
{
    while (1);
}

void GP16C4T1_IRQHandler(void)      /*  IRQ 16  */
{
    while (1);
}

void GP32C4T1_IRQHandler(void)      /*  IRQ 15  */
{
    while (1);
}

void BS16T1_IRQHandler(void)        /*  IRQ 14  */
{
    while (1);
}

void AD16C4T1_IRQHandler(void)      /*  IRQ 13  */
{
    while (1);
}

void ADC_COMP_IRQHandler(void)      /*  IRQ 12  */
{
    while (1);
}

void DMA1_CH345_IRQHandler(void)    /*  IRQ 11  */
{
    while (1);
}

void DMA1_CH12_IRQHandler(void)     /*  IRQ 10  */
{
    while (1);
}

void DMA1_CH0_IRQHandler(void)      /*  IRQ 9   */
{
    while (1);
}

void SPI3_IRQHandler(void)          /*  IRQ 8   */
{
    while (1);
}

void EXTI_4to15_IRQHandler(void)    /*  IRQ 7   */
{
    while (1);
}

void EXTI_2to3_IRQHandler(void)     /*  IRQ 6   */
{
    while (1);
}

void EXTI_0to1_IRQHandler(void)     /*  IRQ 5   */
{
    while (1);
}

void RCU_CSU_IRQHandler(void)      /*  IRQ 4    */
{
    while (1);
}

void WAKEUP_IRQHandler(void)       /*  IRQ 3    */
{
    while (1);
}

void RTC_IRQHandler(void)          /*  IRQ 2    */
{
    while (1);
}

void PVD_IRQHandler(void)          /*  IRQ 1    */
{
    while (1);
}

void WWDT_IRQHandler(void)         /*  IRQ 0    */
{
    while (1);
}

/**
  * @} Exceptions Handlers
  */

/**
  * @} INTERRUPT
  */

/**
  * @} Projects_Examples
  */
/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/
