/**********************************************************************************
 *
 * @file    main.h
 * @brief   header file of main.c
 *
 * @date    23 Nov 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          23 Nov  2021    Ginger          the first version
 *          25 Mar  2022    AE Team         Modify MD Driver
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __MAIN_H__
#define __MAIN_H__

/* Includes -------------------------------------------------------*/
#include <stdio.h>
#include <stdint.h>
#include "es32f0283.h"

#include "md_tick.h"
#include "md_rcu.h"
#include "md_syscfg.h"
#include "md_fc.h"
#include "md_gpio.h"
#include "md_dma.h"
#include "md_aes.h"
#include "md_crc.h"
#include "md_calc.h"
#include "md_kbcu.h"
#include "md_csu.h"
#include "md_rtc.h"
#include "md_exti.h"
#include "md_uart.h"
#include "md_spi.h"
#include "md_i2c.h"
#include "md_timer.h"
#include "md_wwdt.h"
#include "md_iwdt.h"
#include "md_adc.h"
#include "md_cmp.h"

#include "md_utils.h"
#include "ald_usb.h"

#include "boot_conf.h"
#include "boot_fatfs.h"

/* Public Functions -----------------------------------------------------------*/
extern void msc_descriptor_init(void);
extern void usb_dev_loop(void);
extern int usbd_read_packet(uint8_t ep_addr, uint8_t *buffer, uint16_t len);
extern int usbd_write_packet(uint8_t ep_addr, uint8_t *buffer, uint16_t len);
extern uint8_t es_iap_program_words(uint32_t addr, uint8_t *buf, uint32_t len, uint8_t en);
/* Public Init Structure ------------------------------------------------------*/
/* Public Macros --------------------------------------------------------------*/
#define ES_USBD_CDC_UART_BUF_SIZE       (2048)
#if ES_USBD_CDC_UART_BUF_SIZE == 2048
#define ES_GET_USBD_CDC_UART_BUF_GET_INDEX(x)       ((x) & 0x7FF)
#else
#define ES_GET_USBD_CDC_UART_BUF_GET_INDEX(x)       ((x) % (ES_USBD_CDC_UART_BUF_SIZE))
#endif
extern uint8_t usb_cdc_uart_rxbuf[ES_USBD_CDC_UART_BUF_SIZE];
extern uint8_t usb_cdc_data_rxbuf[ES_USBD_CDC_UART_BUF_SIZE];
extern uint32_t rxcount_from_uart;
extern uint32_t txcount_to_uart;
extern uint32_t rxcount_from_usb;
extern uint32_t txcount_to_usb;
extern uint32_t g_write_fatfs_time_ms;
/* Public Constants -----------------------------------------------------------*/
/* Private Variables ----------------------------------------------------------*/
/* Private Macros -------------------------------------------------------------*/
/* Private Constants-----------------------------------------------------------*/
/* Private Functions ----------------------------------------------------------*/

#endif
/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/

