/**********************************************************************************
 *
 * @file
 * @brief
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include <stdio.h>
#include "main.h"
/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */
void usart_init(void);
/**
  * @brief  Initializate system.
  * @retval None
  */
void SystemInit(void)
{

}

/**
  * @brief:  Main program.
  * @param:  None
  * @retval: None
  */
int main()
{
    /* Configure system clock */
    md_cmu_clock_config(MD_CMU_CLOCK_HRC, 32000000);

    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();
    usart_init();
    /* Initialize WWDT */
    md_wwdt_init(32000 * 4, MD_WWDT_WIN_25, ENABLE);

    /* Start WWDT */
    WWDT_UNLOCK();
    md_wwdt_enable();
    WWDT_LOCK();
    NVIC_SetPriority(WWDT_IRQn, 0);
    NVIC_EnableIRQ(WWDT_IRQn);
    printf("wwdt demo\r\n");

    while (1)
    {

    }
}
void usart_gpio_init()
{
    md_gpio_init_t g_gpio_init_s;
    md_gpio_init_struct(&g_gpio_init_s);
    g_gpio_init_s.mode = MD_GPIO_MODE_OUTPUT;
    g_gpio_init_s.func = MD_GPIO_FUNC_3;
    md_gpio_init(USART_PORT, USART_TX_PIN, &g_gpio_init_s);

    g_gpio_init_s.mode = MD_GPIO_MODE_INPUT;
    md_gpio_init(USART_PORT, USART_RX_PIN, &g_gpio_init_s);

    return;
}

void usart_init()
{
    md_usart_init_t g_usart_init_s;

    md_cmu_enable_perh_usart0();
    usart_gpio_init();
    md_usart_init_struct(&g_usart_init_s);
    md_usart_init(USART0, &g_usart_init_s);

    return;
}

int fputc(int c, FILE *f)
{
    while ((READ_BIT(USART0->STAT, USART_STAT_TXEMPIF_MSK)) != USART_STAT_TXEMPIF_MSK);

    USART0->DATA = (uint8_t)c;
    return c;
}
/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
