/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date    23 Sep 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          23 Sep 2021     biyq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <string.h>
#include "md_utils.h"
#include "main.h"
#include "math.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  NMI IRQ handler
  * @retval None
  */
void NMI_Handler(void)
{
    /* Added Emergency operation */
    return;
}

/**
  * @brief  Hardfault IRQ handler, already defined in startup file
  * @retval None
  */

/**
  * @brief  MemManage IRQ handler
  * @retval None
  */
void MemManage_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  BusFault IRQ handler
  * @retval None
  */
void BusFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  UsageFault IRQ handler
  * @retval None
  */
void UsageFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  Supervisor Call IRQ handler
  * @retval None
  */
void SVC_Handler(void)
{
    /* Added system callback */
    return;
}

/**
  * @brief  Debug Monitor IRQ handler
  * @retval None
  */
void DebugMon_Handler(void)
{
    /* Added debug operation */
    return;
}

/**
  * @brief  PendSV IRQ handler
  * @retval None
  */
void PendSV_Handler(void)
{
    /* Added thread switching operation */
    return;
}

/**
  * @brief  SysTick IRQ handler
  * @retval None
  */
void SysTick_Handler(void)
{
    static uint8_t time_flag = 0;

    md_inc_tick();

    if (node1.time_stamp1 > node1.time_stamp2)
    {
        time_flag++;
    }
    else if (time_flag > 1)
    {
        node1.time_stamp1 = 0;
        node1.time_stamp2 = 0;
    }
    else
    {
        /*****************/
    }

    return;
}


/**
  * @brief  EXTI handler
  * @retval None
  */
void EXTI12_15_Handler(void)
{
    md_gpio_init_t x;

    if (md_gpio_is_enabled_external_interrupt(LIN0_RX_PIN) && md_gpio_get_flag(LIN0_RX_PIN))
    {
        /* clear exit interrupt flag */
        md_gpio_clear_flag(LIN0_RX_PIN);

        if (0 == md_gpio_get_input_data(LIN0_PORT, LIN0_RX_PIN))//0 == node1.time_stamp1 ||
        {
            /* record the timestamp once RX pin is pulled down */
            node1.time_stamp1 = md_get_tick();
            /* enable trailing edge trigger */
            md_gpio_enable_riging_edge_trigger(LIN0_RX_PIN);
        }
        else
        {
            /* record the timestamp once RX pin is pulled up */
            node1.time_stamp2 = md_get_tick();

            /* calculate the time difference */
            if (node1.time_stamp1 > node1.time_stamp2)
            {
                node1.breakfield_time = node1.time_stamp2 + (0xFFFFFFFF - node1.time_stamp1);
            }
            else
            {
                node1.breakfield_time = node1.time_stamp2 - node1.time_stamp1;
            }

            /* Judge whether detct lin break flag */
            if ((time_difference_cal(BAUDRATE) > node1.breakfield_time) && ((time_difference_cal(BAUDRATE) - node1.breakfield_time) < (time_difference_cal(BAUDRATE) / 13)))
            {
                /* Change frame stage to sync_stage */
                lin_break_seg_proc(&node1);
                /* Init rx pin for lin */
                x.pupd = MD_GPIO_PUSH_UP;
                x.func  = MD_GPIO_FUNC_3;
                md_gpio_init(LIN0_PORT, LIN0_RX_PIN, &x);
                /* Enable USART0 irq */
                md_mcu_irq_config(USART0_IRQn, 0, ENABLE);
            }
            else if ((time_difference_cal(BAUDRATE) < node1.breakfield_time) && (node1.breakfield_time - (time_difference_cal(BAUDRATE)) < (time_difference_cal(BAUDRATE) / 13)))
            {
                /* Change frame stage to sync_stage */
                lin_break_seg_proc(&node1);
                /* Init rx pin for lin */
                x.pupd = MD_GPIO_PUSH_UP;
                x.func  = MD_GPIO_FUNC_3;
                md_gpio_init(LIN0_PORT, LIN0_RX_PIN, &x);
                /* Enable USART0 irq */
                md_mcu_irq_config(USART0_IRQn, 0, ENABLE);
            }
            else
            {
                /* enable trailing edge trigger */
                md_gpio_disable_riging_edge_trigger(LIN0_RX_PIN);
                md_gpio_enable_trailing_edge_trigger(LIN0_RX_PIN);
            }
        }
    }

    return;
}

/**
  * @brief:  This function handles UART0 exception.
  * @param:  None
  * @retval: None
  */
void USART0_Handler(void)
{
    if (md_usart_is_enabled_it_rxne(USART0) && md_usart_is_active_flag_rxne(USART0))
    {
        md_usart_clear_flag_rxne(USART0);

        /*  */
        lin_recv_data_proc(&node1, md_usart_recv_data8(USART0));

    }
}


/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
