/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
/* Private Macros ------------------------------------------------------------ */
md_usart_init_t g_h_usart;

/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */
/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Initializate system.
  * @retval None
  */
void SystemInit(void)
{

}

/**
  * @brief  Initializate pin of usart module.
  * @retval None
  */
static void usart_pin_init(void)
{
    md_gpio_init_t x;
    md_gpio_init_struct(&x);

    /* Initialize tx pin */
    x.mode = MD_GPIO_MODE_OUTPUT;
    x.odos = MD_GPIO_PUSH_PULL;
    x.pupd = MD_GPIO_PUSH_UP;
    x.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
    x.flt  = MD_GPIO_FILTER_DISABLE;
    x.type = MD_GPIO_TYPE_CMOS;
    x.func = MD_GPIO_FUNC_3;
    md_gpio_init(USART_TX_PORT, USART_TX_PIN, &x);

    /* Initialize rx pin */
    x.mode = MD_GPIO_MODE_INPUT;
    x.odos = MD_GPIO_PUSH_PULL;
    x.pupd = MD_GPIO_PUSH_UP;
    x.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
    x.flt  = MD_GPIO_FILTER_DISABLE;
    x.type = MD_GPIO_TYPE_CMOS;
    x.func = MD_GPIO_FUNC_3;
    md_gpio_init(USART_RX_PORT, USART_RX_PIN, &x);

    return;
}

/**
  * @brief:  Initialize the usart.
  * @param:  None
  * @retval: None
  */
static void usart_init(void)
{
    md_usart_init_struct(&g_h_usart);
    /* Initialize USART */
    g_h_usart.baud        = 2400;
    g_h_usart.word_length = MD_USART_WORD_LENGTH_9B;
    g_h_usart.stop_bits   = MD_USART_STOP_BITS_1;
    g_h_usart.parity      = MD_USART_PARITY_NONE;
    g_h_usart.fctl        = MD_USART_HW_FLOW_CTL_NONE;
    g_h_usart.mode        = MD_USART_MODE_TX_RX;
    md_usart_init(USARTX, &g_h_usart);

    md_usart_enable_it_txc(USARTX);
    md_usart_enable_it_rxne(USARTX);
}

/**
  * @brief  Initialize TIMER.
  * @param  None
  * @retval None
  */
void timer_init(void)
{
    md_timer_base_init_t tim_init;
    md_timer_oc_init_t oc_init;
    md_timer_base_struct_init(&tim_init);
    md_timer_oc_struct_init(&oc_init);

    tim_init.prescaler   = 0;
    tim_init.mode        = MD_TIMER_CNT_MODE_UP;
    tim_init.period      = 842;
    tim_init.clk_div     = MD_TIMER_CLOCK_DIV1;
    tim_init.re_cnt      = 0;
    md_timer_base_set_config(AD16C4T, &tim_init);

    oc_init.ocstate      = MD_TIMER_OCSTATE_ENABLE;
    oc_init.ocnstate     = MD_TIMER_OCSTATE_ENABLE;
    oc_init.oc_mode      = MD_TIMER_OC_MODE_PWM2;
    oc_init.oc_polarity  = MD_TIMER_OC_POLARITY_HIGH;
    oc_init.ocn_polarity = MD_TIMER_OCN_POLARITY_HIGH;
    oc_init.oc_fast_en   = DISABLE;
    oc_init.oc_idle      = MD_TIMER_OC_IDLE_RESET;
    oc_init.ocn_idle     = MD_TIMER_OCN_IDLE_RESET;
    oc_init.pulse        = 421;
    md_timer_oc_init(AD16C4T, MD_TIMER_CHANNEL_1, &oc_init);

    md_timer_set_main_output_enable(AD16C4T, 1);
    md_timer_enable_counter_cnten(AD16C4T);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Configure system clock */
    md_cmu_clock_config(MD_CMU_CLOCK_HRC, 32000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    md_pis_set_usart0_mod_src(PIS, MD_PIS_SRC_AD16C4T);
    md_pis_set_usart0_mod_tim_channel(PIS, MD_PIS_TIMER_CH1);
    md_pis_set_usart0_tx_mod_low(PIS);

    timer_init();

    /* Enable and Set priority for USART_IRQn */
    md_mcu_irq_config(USART0_IRQn, 0, ENABLE);

    usart_pin_init();

    usart_init();

    while (1)
    {
        /* strongly recommend to clear idle flag in main loop */
        if (md_usart_is_active_flag_idle(USARTX))
            md_usart_clear_flag_idle(USARTX);
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
