/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <string.h>
#include "main.h"
void SystemInit()
{}
/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

char g_tx0_buf[64] = "USART0 : ";
uint32_t g_tx0_len;
uint32_t g_tx0_i = 0U;

char g_tx1_buf[64] = "USART1 : ";
uint32_t g_tx1_len;
uint32_t g_tx1_i = 0U;

md_usart_init_t g_h_usart;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Initializate pin of usart module.
  * @retval None
  */
static void usart_pin_init(void)
{
    md_gpio_init_t x;
    md_gpio_init_struct(&x);

    /* Initialize usart0_tx pin */
    x.mode = MD_GPIO_MODE_OUTPUT;
    x.odos = MD_GPIO_OPEN_DRAIN;
    x.pupd = MD_GPIO_PUSH_UP;
    x.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
    x.flt  = MD_GPIO_FILTER_DISABLE;
    x.type = MD_GPIO_TYPE_CMOS;
    x.func = MD_GPIO_FUNC_3;
    md_gpio_init(USART0_TX_PORT, USART0_TX_PIN, &x);

    /* Initialize usart0_rx pin */
    x.mode = MD_GPIO_MODE_INPUT;
    x.odos = MD_GPIO_OPEN_DRAIN;
    x.pupd = MD_GPIO_PUSH_UP;
    x.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
    x.flt  = MD_GPIO_FILTER_DISABLE;
    x.type = MD_GPIO_TYPE_CMOS;
    x.func = MD_GPIO_FUNC_3;
    md_gpio_init(USART0_RX_PORT, USART0_RX_PIN, &x);

    /* Initialize usart1_tx pin */
    x.mode = MD_GPIO_MODE_OUTPUT;
    x.odos = MD_GPIO_OPEN_DRAIN;
    x.pupd = MD_GPIO_PUSH_UP;
    x.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
    x.flt  = MD_GPIO_FILTER_DISABLE;
    x.type = MD_GPIO_TYPE_CMOS;
    x.func = MD_GPIO_FUNC_7;
    md_gpio_init(USART1_TX_PORT, USART1_TX_PIN, &x);

    /* Initialize usart1_rx pin */
    x.mode = MD_GPIO_MODE_INPUT;
    x.odos = MD_GPIO_OPEN_DRAIN;
    x.pupd = MD_GPIO_PUSH_UP;
    x.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
    x.flt  = MD_GPIO_FILTER_DISABLE;
    x.type = MD_GPIO_TYPE_CMOS;
    x.func = MD_GPIO_FUNC_7;
    md_gpio_init(USART1_RX_PORT, USART1_RX_PIN, &x);

    return;
}

/**
  * @brief:  Initialize the usart.
  * @param:  None
  * @retval: None
  */
static void usart_init(void)
{
    md_usart_init_struct(&g_h_usart);
    /* Initialize USART0 and USART1 */
    g_h_usart.baud        = 115200;
    g_h_usart.word_length = MD_USART_WORD_LENGTH_9B;
    g_h_usart.stop_bits   = MD_USART_STOP_BITS_1;
    g_h_usart.parity      = MD_USART_PARITY_NONE;
    g_h_usart.fctl        = MD_USART_HW_FLOW_CTL_NONE;
    g_h_usart.mode        = MD_USART_MODE_TX_RX;
    md_usart_init(USART0, &g_h_usart);
    md_usart_init(USART1, &g_h_usart);

    /* Set the way of waking up */
    md_usart_set_wakeup_mode(USART0, MD_USART_WAKEUP_ADDR);
    md_usart_set_wakeup_mode(USART1, MD_USART_WAKEUP_ADDR);
    /* Set waking up address */
    md_usart_set_addr(USART0, 0xF);
    md_usart_set_addr(USART1, 0x1);
    /* Enable mute mode */
    md_usart_enter_mute_mode(USART0);
    md_usart_enter_mute_mode(USART1);

    /* Enable USART interrupt */
    md_usart_enable_it_rxne(USART0);
    md_usart_enable_it_rxne(USART1);
}

/**
  * @brief:  Main program.
  * @param:  None
  * @retval: None
  */
int main()
{
    /* Configure system clock */
    md_cmu_clock_config(MD_CMU_CLOCK_HRC, 32000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    md_mcu_irq_config(USART0_IRQn, 0, ENABLE);
    md_mcu_irq_config(USART1_IRQn, 0, ENABLE);
    g_tx0_len = strlen((const char *)g_tx0_buf);
    g_tx1_len = strlen((const char *)g_tx1_buf);

    usart_pin_init();

    /* Init USART */
    usart_init();

    while (1)
    {
        /* strongly recommend to clear idle flag in main loop */
        if (md_usart_is_active_flag_idle(USART0))
            md_usart_clear_flag_idle(USART0);

        /* strongly recommend to clear idle flag in main loop */
        if (md_usart_is_active_flag_idle(USART1))
            md_usart_clear_flag_idle(USART1);
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
