/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include <stdio.h>
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */
void SystemInit(void)
{}
/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
/* Private Variables --------------------------------------------------------- */
static char flash_txbuf[32] = "essemi mcu spi flash example!";     /*Length must be less than one page (256 bytes)*/
static char flash_rxbuf[32];

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    uint32_t id;
    md_status_t status;

    /* Configure system clock */
    md_cmu_clock_config(MD_CMU_CLOCK_HRC, 32000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    mcu_usart_init();    /*To initialize the UART module*/
    mcu_spi_init();     /*Initialize the SPI module*/

    id = flash_read_id();
    printf("\r\nManufacturer ID is %02x & Device ID is %02x %02x\r\n", (uint8_t)(id >> 16), (uint8_t)(id >> 8), (uint8_t)id);

    printf("Now erase the sector containing address 0...\r\n");
    status = flash_sector_erase(0);

    if (status == MD_OK)
    {
        flash_wait_unbusy();    /*Waiting for erasing*/
        printf("Erase OK!\r\n");
    }

    printf("The date written to flash is -> %s\r\n", flash_txbuf);
    status = flash_write(0, flash_txbuf, strlen(flash_txbuf) + 1);

    if (status == MD_OK)
    {
        flash_wait_unbusy();    /*Waiting for the written to complete*/
        printf("Write OK!\r\n");
    }

    status = flash_read(0, flash_rxbuf, strlen(flash_txbuf) + 1);   /*Read write data*/
    printf("The data read from flash is  -> %s\r\n", flash_rxbuf);

    if (!memcmp(flash_txbuf, flash_rxbuf, strlen(flash_txbuf) + 1))   /*Data is written and read*/
        printf("Read OK!\r\n");
    else
        printf("Read ERROR!\r\n");

    while (1)
        ;
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
