/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include "main.h"


/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/** @addtogroup Core Processor Exceptions and Peripheral Interrupt HANDLER
  * @{
  */

/****************** Core Processor Exceptions HANDLER ************************/
/**
  * @brief  NMI IRQ HANDLER
  * @param  None
  * @retval None
  */
void NMI_Handler(void)
{
    /* Added Emergency operation */
    return;
}

/**
  * @brief  Hardfault IRQ handler, already defined in startup file
  * @retval None
  */

/**
  * @brief  Supervisor Call IRQ HANDLER
  * @param  None
  * @retval None
  */
void SVC_Handler(void)
{
    /* Added system callback */
    return;
}

/**
  * @brief  Debug Monitor IRQ HANDLER
  * @param  None
  * @retval None
  */
void DebugMon_Handler(void)
{
    /* Added debug operation */
    return;
}

/**
  * @brief  PendSV IRQ HANDLER
  * @param  None
  * @retval None
  */
void PendSV_Handler(void)
{
    /* Added thread switching operation */
    return;
}

/**
  * @brief  SysTick IRQ HANDLER
  * @param  None
  * @retval None
  */
void SysTick_Handler(void)
{
    md_inc_tick();
    return;
}

/**
  * @brief  DMA IRQ HANDLER
  * @param  None
  * @retval None
  */
void DMA_Handler(void)
{
    if (md_dma_is_enabled_it_done(MD_DMA_CH_1) && md_dma_is_active_flag_done(MD_DMA_CH_1))
    {
        md_dma_clear_flag_done(MD_DMA_CH_1);

        md_spi_disable_rx_dma(SPI0);

        md_dma_config_base(DMA0, MD_DMA_CYCLE_CTRL_BASIC, &g_rx_config);
        /*Enable the DMA channel*/
        md_dma_enable_channel(MD_DMA_CH_1);
        /*Enabling SPI DMA to receive*/
        md_spi_enable_rx_dma(SPI0);

    }

    if (md_dma_is_enabled_it_done(MD_DMA_CH_0) && md_dma_is_active_flag_done(MD_DMA_CH_0))
    {
        md_dma_clear_flag_done(MD_DMA_CH_0);

        md_spi_disable_tx_dma(SPI0);

        md_dma_config_base(DMA0, MD_DMA_CYCLE_CTRL_BASIC, &g_tx_config);
        /*Enable the DMA channel*/
        md_dma_enable_channel(MD_DMA_CH_0);
        /*Enabling SPI DMA to send*/
        md_spi_enable_tx_dma(SPI0);

    }

}
/**
  * @} Core Processor Exceptions and Peripheral Interrupt HANDLER
  */

/**
  * @} Examples
  */

/**
  * @} Projects_Examples_ALD
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
