/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for demo
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <string.h>
#include "main.h"
void SystemInit()
{}

/* Private Macros ------------------------------------------------------------ */

#define HIGH_FIRST     /*The clock polarity and clock phase*/

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/**
  * @brief Initialization Structure of spi module.
  */
md_spi_init_t g_h_spi;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples_SPI
  * @{
  */

/*From machine mode communication pins initialization function*/
void spi_pin_init(void)
{
    md_gpio_init_t x;

    /*From machine initialization, SCK pin configuration for the input mode*/
    x.mode = MD_GPIO_MODE_INPUT;
    x.odos = MD_GPIO_PUSH_PULL;
    x.pupd = MD_GPIO_PUSH_UP;
    x.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
    x.flt  = MD_GPIO_FILTER_DISABLE;
    x.type = MD_GPIO_TYPE_CMOS;
    x.func = MD_GPIO_FUNC_2;
    md_gpio_init(GPIO_PORT, SPI_SCK_PIN, &x);

    /*From machine initialization MISO pins, configured to output mode*/
    x.mode = MD_GPIO_MODE_OUTPUT;
    x.odos = MD_GPIO_PUSH_PULL;
    x.pupd = MD_GPIO_PUSH_UP;
    x.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
    x.flt  = MD_GPIO_FILTER_DISABLE;
    x.type = MD_GPIO_TYPE_CMOS;
    x.func = MD_GPIO_FUNC_2;
    md_gpio_init(GPIO_PORT, SPI_MISO_PIN, &x);

    /*From machine initialization, MOSI pin configured as input mode*/
    x.mode = MD_GPIO_MODE_INPUT;
    x.odos = MD_GPIO_PUSH_PULL;
    x.pupd = MD_GPIO_PUSH_UP;
    x.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
    x.flt  = MD_GPIO_FILTER_DISABLE;
    x.type = MD_GPIO_TYPE_CMOS;
    x.func = MD_GPIO_FUNC_2;
    md_gpio_init(GPIO_PORT, SPI_MOSI_PIN, &x);

    /*From machine initialization, NSS pin configured as input mode*/
    x.mode = MD_GPIO_MODE_INPUT;
    x.odos = MD_GPIO_PUSH_PULL;
    x.pupd = MD_GPIO_PUSH_UP;
    x.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
    x.flt  = MD_GPIO_FILTER_DISABLE;
    x.type = MD_GPIO_TYPE_CMOS;
    x.func = MD_GPIO_FUNC_2;
    md_gpio_init(GPIO_PORT, SPI_NSS_PIN, &x);

    return;
}

/*SPI configuration function*/
void spi_struct_user(md_spi_init_t *init)
{
    init->mode      = MD_SPI_MODE_SLAVER;       /*From the machine model*/
    init->dir       = MD_SPI_DIRECTION_2LINES;      /*Full duplex*/
    init->data_size = MD_SPI_DATA_SIZE_8;
    init->baud      = MD_SPI_BAUD_2;

#ifdef HIGH_FIRST       /*Free clock high level, the first clock edge sampling data*/
    init->phase     = MD_SPI_CPHA_FIRST;
    init->polarity  = MD_SPI_CPOL_HIGH;

#elif defined HIGH_SECOND       /*Free clock high level, the second clock edge sampling data*/
    init->phase     = MD_SPI_CPHA_SECOND;
    init->polarity  = MD_SPI_CPOL_HIGH;

#elif defined LOW_FIRST     /*Free clock low level, the first clock edge sampling data*/
    init->phase     = MD_SPI_CPHA_FIRST;
    init->polarity  = MD_SPI_CPOL_LOW;

#elif defined LOW_SECOND        /*Free clock low level, the second clock edge sampling data*/
    init->phase     = MD_SPI_CPHA_SECOND;
    init->polarity  = MD_SPI_CPOL_LOW;
#endif /*HIGH_FIRST*/

    init->first_bit = MD_SPI_FIRSTBIT_MSB;      /*High in the former*/
    init->ss_en     = DISABLE;
    init->crc_calc  = DISABLE;
    init->crc_poly  = 0;
}

/*The main function*/
int main()
{
    /* Configure system clock */
    md_cmu_clock_config(MD_CMU_CLOCK_HRC, 32000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    /*Pin initialization*/
    spi_pin_init();

    /*Empty the SPI initialization structure*/
    memset(&g_h_spi, 0x0, sizeof(g_h_spi));

    /*The SPI initialization structure is set to the default values*/
    md_spi_struct_init(&g_h_spi);

    /*User configuration SPI*/
    spi_struct_user(&g_h_spi);

    /*SPI initialization*/
    md_spi_init(SPI0, &g_h_spi);

    /*SPI interrupt initialization: set the interrupt priority and can interrupt*/
    NVIC_SetPriority(SPI0_IRQn, 0);
    NVIC_EnableIRQ(SPI0_IRQn);

    /*Can send air circuit*/
    md_spi_enable_txe_interrupt(SPI0);
    /*Make to receive the air break*/
    md_spi_enable_rxne_interrupt(SPI0);

    while (1);
}

/**
  * @} Examples_SPI
  */

/**
  * @} Projects_Examples_MD
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
