/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *          23 August  2021    yanght       传输完成后拉高NSS
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Variables --------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Macros ------------------------------------------------------------ */
#define HIGH_FIRST     /*The clock polarity and clock phase*/

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples_SPI
  * @{
  */
/* Public Variables ---------------------------------------------------------- */
md_spi_init_t g_h_spi;
uint8_t g_send_buf[8] = {0x12U, 0x23U, 0x34U, 0x45U, 0x56U, 0x67U, 0x78U, 0x89U};
uint8_t g_recv_buf[8] = {0U};
uint8_t g_send_len = sizeof(g_send_buf);
uint8_t g_recv_len = sizeof(g_recv_buf);
uint8_t g_send_ind = 0U;
uint8_t g_recv_ind = 0U;
/* Private Function ---------------------------------------------------------- */
void SystemInit()
{

}

/*Host mode communication pins initialization function*/
void spi_pin_init(void)
{
    md_gpio_init_t x;

    /*Host SCK pin initialization, configuration for the output mode*/
    x.mode = MD_GPIO_MODE_OUTPUT;
    x.odos = MD_GPIO_PUSH_PULL;
    x.pupd = MD_GPIO_PUSH_UP;
    x.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
    x.flt  = MD_GPIO_FILTER_DISABLE;
    x.type = MD_GPIO_TYPE_CMOS;
    x.func = MD_GPIO_FUNC_2;
    md_gpio_init(GPIO_PORT, SPI_SCK_PIN, &x);

    /*Host MISO pins initialization, configuration for the input mode*/
    x.mode = MD_GPIO_MODE_INPUT;
    x.odos = MD_GPIO_PUSH_PULL;
    x.pupd = MD_GPIO_PUSH_UP;
    x.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
    x.flt  = MD_GPIO_FILTER_DISABLE;
    x.type = MD_GPIO_TYPE_CMOS;
    x.func = MD_GPIO_FUNC_2;
    md_gpio_init(GPIO_PORT, SPI_MISO_PIN, &x);

    /*Host MOSI pin initialization, configuration for the output mode*/
    x.mode = MD_GPIO_MODE_OUTPUT;
    x.odos = MD_GPIO_PUSH_PULL;
    x.pupd = MD_GPIO_PUSH_UP;
    x.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
    x.flt  = MD_GPIO_FILTER_DISABLE;
    x.type = MD_GPIO_TYPE_CMOS;
    x.func = MD_GPIO_FUNC_2;
    md_gpio_init(GPIO_PORT, SPI_MOSI_PIN, &x);

    /*Host NSS pin initialization, configuration for the output mode*/
    x.mode = MD_GPIO_MODE_OUTPUT;
    x.odos = MD_GPIO_PUSH_PULL;
    x.pupd = MD_GPIO_PUSH_UP;
    x.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
    x.flt  = MD_GPIO_FILTER_DISABLE;
    x.type = MD_GPIO_TYPE_CMOS;
    x.func = MD_GPIO_FUNC_1;        /* GPIO */
    md_gpio_init(GPIO_PORT, SPI_NSS_PIN, &x);
    md_gpio_set_pin_high(GPIO_PORT, SPI_NSS_PIN);
}

/*SPI configuration function*/
void spi_struct_user(md_spi_init_t *init)
{
    init->mode      = MD_SPI_MODE_MASTER;       /*Host mode*/
    init->dir       = MD_SPI_DIRECTION_2LINES;      /*Full duplex*/
    init->data_size = MD_SPI_DATA_SIZE_8;
    init->baud      = MD_SPI_BAUD_16;

#ifdef HIGH_FIRST       /*Free clock high level, the first clock edge sampling data*/
    init->phase     = MD_SPI_CPHA_FIRST;
    init->polarity  = MD_SPI_CPOL_HIGH;

#elif defined HIGH_SECOND       /*Free clock high level, the second clock edge sampling data*/
    init->phase     = MD_SPI_CPHA_SECOND;
    init->polarity  = MD_SPI_CPOL_HIGH;

#elif defined LOW_FIRST     /*Free clock low level, the first clock edge sampling data*/
    init->phase     = MD_SPI_CPHA_FIRST;
    init->polarity  = MD_SPI_CPOL_LOW;

#elif defined LOW_SECOND        /*Free clock low level, the second clock edge sampling data*/
    init->phase     = MD_SPI_CPHA_SECOND;
    init->polarity  = MD_SPI_CPOL_LOW;
#endif  /* phase_polarity */

    init->first_bit = MD_SPI_FIRSTBIT_MSB;      /*High in the former*/
    init->ss_en     = DISABLE;
    init->crc_calc  = DISABLE;
    init->crc_poly  = 0;
}

/*The main function*/
int main()
{
    /* Configure system clock */
    md_cmu_clock_config(MD_CMU_CLOCK_HRC, 32000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    /*SPI interrupt initialization: set the interrupt priority and can interrupt*/
    NVIC_SetPriority(SPI0_IRQn, 0);
    NVIC_EnableIRQ(SPI0_IRQn);

    /*Pin initialization*/
    spi_pin_init();

    /*Empty the SPI initialization structure*/
    memset(&g_h_spi, 0, sizeof(g_h_spi));

    /*The SPI initialization structure is set to the default values*/
    md_spi_struct_init(&g_h_spi);
    /*User configuration SPI*/
    spi_struct_user(&g_h_spi);
    /*SPI initialization*/
    md_spi_init(SPI0, &g_h_spi);

    /*Make to receive the air break*/
    md_spi_enable_rxne_interrupt(SPI0);

    /*Lower NSS pin to select the external from the machine*/
    md_gpio_set_pin_low(GPIO_PORT, SPI_NSS_PIN);

    /* 使能发送空中断 */
    md_spi_enable_txe_interrupt(SPI0);

    while (md_spi_is_enable_txe_interrupt(SPI0));

    while (g_recv_ind != 0);

    while (g_send_ind != 0);

    md_gpio_set_pin_high(GPIO_PORT, SPI_NSS_PIN);

    while (1);
}

/**
  * @} Examples_SPI
  */

/**
  * @} Projects_Examples_MD
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
