/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples_SPI
  * @{
  */
/* Private Variables --------------------------------------------------------- */
/* Private Macros ------------------------------------------------------------ */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */
/****************** Core Processor Exceptions HANDLER ************************/
/**
  * @brief  NMI IRQ HANDLER
  * @param  None
  * @retval None
  */
void NMI_Handler(void)
{
    /* Added Emergency operation */
    return;
}

/**
  * @brief  Hardfault IRQ handler, already defined in startup file
  * @retval None
  */

/**
  * @brief  Supervisor Call IRQ HANDLER
  * @param  None
  * @retval None
  */
void SVC_Handler(void)
{
    /* Added system callback */
    return;
}

/**
  * @brief  Debug Monitor IRQ HANDLER
  * @param  None
  * @retval None
  */
void DebugMon_Handler(void)
{
    /* Added debug operation */
    return;
}

/**
  * @brief  PendSV IRQ HANDLER
  * @param  None
  * @retval None
  */
void PendSV_Handler(void)
{
    /* Added thread switching operation */
    return;
}

/**
  * @brief  SysTick IRQ HANDLER
  * @param  None
  * @retval None
  */
void SysTick_Handler(void)
{
    md_inc_tick();
    return;
}

/****************** Peripheral Interrupt HANDLER ************************/
/*The SPI interrupt service function*/
void SPI0_Handler(void)
{
    if (md_spi_is_enable_rxne_interrupt(SPI0) && md_spi_is_active_flag_rxbne(SPI0))
    {
        g_recv_buf[g_recv_ind++] = md_spi_get_data_reg_value(SPI0);

        if (g_recv_ind >= g_recv_len)
        {
            g_recv_ind = 0;
        }
    }

    if (md_spi_is_enable_txe_interrupt(SPI0) && md_spi_is_active_flag_txbe(SPI0))
    {
        if (g_send_ind < g_send_len)
        {
            md_spi_set_data_reg(SPI0, g_send_buf[g_send_ind++]);
        }
        else
        {
            g_send_ind = 0;
            md_spi_disable_txe_interrupt(SPI0);
        }
    }

}

/**
  * @} Examples_SPI
  */

/**
  * @} Projects_Examples_ALD
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
