/**********************************************************************************
 *
 * @file    main.h
 * @brief   header file of main.c
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__

/* Includes ------------------------------------------------------------------ */
#include "md_conf.h"
#include <stdio.h>
#include <string.h>

/* Exported Macros ----------------------------------------------------------- */

/* SPI0 IO pin definition */
#define GPIO_PORT  GPIOA
#define SPI_NSS_PIN  MD_GPIO_PIN_0
#define SPI_SCK_PIN  MD_GPIO_PIN_10
#define SPI_MOSI_PIN MD_GPIO_PIN_11
#define SPI_MISO_PIN MD_GPIO_PIN_12

/* Exported Types ------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
extern uint8_t g_send_buf[8] ;
extern uint8_t g_recv_buf[8] ;
extern uint8_t g_send_len ;
extern uint8_t g_recv_len ;
extern uint8_t g_send_ind ;
extern uint8_t g_recv_ind ;
/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */
#endif  /* __MAIN_H__ */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
