/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include "main.h"


/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Hardfault IRQ handler, already defined in startup file
  * @retval None
  */

/**
  * @brief  SysTick IRQ handler
  * @retval None
  */
void SysTick_Handler(void)
{
    md_inc_tick();
    return;
}

/**
  * @brief  CMU IRQ handler
  * @retval None
  */
void CMU_Handler(void)
{
    if ((md_cmu_is_enabled_hosc_stp_interrupt()) && (md_cmu_is_active_flag_hosc_stp()))
    {
        SYSCFG_UNLOCK();
        md_cmu_clear_flag_hosc_stp();
        SYSCFG_LOCK();
        /* system rescue code in hosc fault  */
    }

    return;
}

/**
  * @brief  NMI handler
  * @retval None
  */
void NMI_Handler(void)
{
    if ((md_cmu_is_enabled_hosc_nmi_interrupt()) && (md_cmu_is_active_flag_hosc_stp()))
    {
        SYSCFG_UNLOCK();
        md_cmu_clear_flag_hosc_stp();
        SYSCFG_LOCK();
        /* system rescue code in hosc fault  */
    }

    return;
}

/**
  * @brief  LVD handler
  * @retval None
  */
void LVD_Handler(void)
{
    if (md_pmu_is_enable_lvd_it() && md_pmu_is_active_flag_lvd_it())
    {
        SYSCFG_UNLOCK();
        md_pmu_set_lvd_it_flag(); /* clear LVD interrupt flag */
        SYSCFG_LOCK();
        NVIC_SystemReset();
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
