/**********************************************************************************
 *
 * @file    bat.c
 * @brief   bat file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "bat.h"
#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples_PMU
  * @{
  */

/* Private Macros ------------------------------------------------------------ */
/* Only one macro can be opened at a time */
#define LP_MODE_SLEEP
//#define LP_MODE_STOP

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Initializate lvd.
  * @retval None
  */
void init_lvd_powerup(void)
{
    SYSCFG_UNLOCK();
    md_pmu_lvd_config(MD_PMU_LVD_VOL_SEL_3_6, MD_PMU_LVD_TRIGGER_LOW_LEVEL, ENABLE);
    md_pmu_enable_lvd_it();
    md_pmu_set_lvd_it_flag(); /* clear LVD interrupt flag */
    SYSCFG_LOCK();
    NVIC_ClearPendingIRQ(LVD_IRQn);

    md_mcu_irq_config(LVD_IRQn, 0, ENABLE);
    return;
}

/**
  * @brief  Test battery function
  * @retval Status.
  */
void bat_proc(void)
{
    uint16_t i = 0;
    uint16_t j = 0;
    CLEAR_BIT(SysTick->CTRL, SysTick_CTRL_ENABLE_Msk);
    __disable_irq();
    init_pin();
    init_lvd_powerup();

    while (1)
    {
        if (md_gpio_is_enabled_external_interrupt(PMU_EXTI_PIN) && \
                (md_gpio_get_flag(PMU_EXTI_PIN) == SET))
        {
            md_gpio_clear_flag(PMU_EXTI_PIN);
//            md_gpio_toggle_pin_output(LED_PORT, LED_PIN);
            NVIC_ClearPendingIRQ(EXTI4_7_IRQn);
        }

        if (md_pmu_is_enable_lvd_it() && md_pmu_is_active_flag_lvd_it())
        {
            SYSCFG_UNLOCK();
            md_pmu_set_lvd_it_flag(); /* clear LVD interrupt flag */
            SYSCFG_LOCK();
//            md_gpio_toggle_pin_output(LED_PORT, LED_PIN);
            NVIC_SystemReset();
        }

        if (READ_BIT(SCB->ICSR, SCB_ICSR_PENDSTSET_Msk) == SCB_ICSR_PENDSTSET_Msk)
        {
            SYSCFG_UNLOCK();
            SET_BIT(SCB->ICSR, SCB_ICSR_PENDSTCLR_Msk);
            SYSCFG_LOCK();
        }

#ifdef LP_MODE_SLEEP
        md_pmu_sleep_enter();
#endif /* LP_MODE_SLEEP */
#ifdef LP_MODE_STOP
        md_pmu_stop_enter();
#endif /* LP_MODE_STOP*/
        md_gpio_set_pin_low(LED_PORT, LED_PIN);

        for (i = 0; i < 1000; i++)
            for (j = 0; j < 1000; j++);

        md_gpio_set_pin_high(LED_PORT, LED_PIN);
    }
}

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
