/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"

void SystemInit()
{}
/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/* Private Macros ------------------------------------------------------------ */
/* Only one macro can be opened at a time */
//#define LP_MODE_SLEEP
#define LP_MODE_STOP

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Pins initialization function
  * @retval None.
  */
void init_pin(void)
{
    md_gpio_init_t gpio_init;

    /*SWDIO and SWDCLK pin configuration for the output mode*/
    md_gpio_init_struct(&gpio_init);      /* initialize the gpio_init */
    gpio_init.mode = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos = MD_GPIO_PUSH_PULL;
    gpio_init.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.pupd = MD_GPIO_FLOATING;
    gpio_init.func = MD_GPIO_FUNC_1;
    md_gpio_init(GPIOB, MD_GPIO_PIN_0, &gpio_init);
    md_gpio_init(GPIOB, MD_GPIO_PIN_1, &gpio_init);
    md_gpio_set_pin_low(GPIOB, MD_GPIO_PIN_0);
    md_gpio_set_pin_low(GPIOB, MD_GPIO_PIN_1);

    /* Initialize GPIO as input */
    md_gpio_init_struct(&gpio_init);      /* initialize the gpio_init */
    gpio_init.mode  = MD_GPIO_MODE_INPUT;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_FLOATING;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_1;
    md_gpio_init(PMU_EXTI_PORT, PMU_EXTI_PIN, &gpio_init);

    /* Initialize external interrupt */
    md_gpio_interrupt_filter_time_set(10U);        /* set filter times: ((10 + 1) * 2)CLOCK */
    md_gpio_interrupt_filter_enable(PMU_EXTI_PIN); /* enable exit filter */

    md_gpio_set_interrupt_port(PMU_EXTI_PORT, PMU_EXTI_PIN);      /* set exit interrupt port */
    md_gpio_enable_riging_edge_trigger(PMU_EXTI_PIN); /* enable riging edge trigger */
    md_gpio_enable_external_interrupt(PMU_EXTI_PIN);  /* enable exti6 */
    md_mcu_irq_config(EXTI4_7_IRQn, 0, ENABLE);      /* enable NVIC EXTI4_7_IRQn */

    /* Initialize LED port */
    md_gpio_init_struct(&gpio_init);      /* initialize the gpio_init */
    gpio_init.odos = MD_GPIO_PUSH_PULL;
    gpio_init.pupd = MD_GPIO_FLOATING;
    gpio_init.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt  = MD_GPIO_FILTER_DISABLE;
    gpio_init.type = MD_GPIO_TYPE_CMOS;
    gpio_init.func = MD_GPIO_FUNC_1;

    md_gpio_init(LED_PORT, LED_PIN, &gpio_init);
    md_gpio_set_pin_high(LED_PORT, LED_PIN);

    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Configure system clock */
    md_cmu_clock_config(MD_CMU_CLOCK_HRC, 32000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();
    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();
    /*Pin initialization*/
    init_pin();

    while (1)
    {
        /* Enter low power mode */
#ifdef LP_MODE_SLEEP
        md_pmu_sleep_enter();
#endif /* LP_MODE_SLEEP */

#ifdef LP_MODE_STOP
        md_pmu_stop_enter();
#endif /* LP_MODE_STOP */
        md_gpio_set_pin_low(LED_PORT, LED_PIN);
        md_delay_1ms(100);
        md_gpio_set_pin_high(LED_PORT, LED_PIN);
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
