/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    31 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          31 Jan. 2023    shicc           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"
#include "eeprom.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */
/* Virtual address defined by the user: 0xFFFFFFFF value is prohibited */
uint32_t g_virt_add_var_tab[NB_OF_VAR] = {0x5555U, 0x6666U, 0x7777U};
uint32_t g_var_data_tab[NB_OF_VAR] = {0U, 0U, 0U};
uint32_t g_var_value = 0U;

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */
/**
	* @brief  Initializate system.
  * @retval None
  */
void SystemInit(void)
{

}

/**
  * @brief  Main program.
  * @param  None
  * @retval None
  */
int main(void)
{
    /* Configure system clock */
    md_cmu_clock_config(MD_CMU_CLOCK_HRC, 32000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    /* 2bits preempt-priority(0-3)
       2bits sub-priority(0-3). */


    __disable_irq();

    /* EEPROM Init */
    ee_init();

    /* --- Store successively many values of the three variables in the EEPROM ---*/
    /* Store 0x1000 values of Variable1 in EEPROM */
    for (g_var_value = 1; g_var_value <= 0x1000; g_var_value++)
        ee_write_variable(g_virt_add_var_tab[0], g_var_value);

    /* read the last stored variables data*/
    ee_read_variable(g_virt_add_var_tab[0], &g_var_data_tab[0]);

    /* Store 0x2000 values of Variable2 in EEPROM */
    for (g_var_value = 1; g_var_value <= 0x2000; g_var_value++)
        ee_write_variable(g_virt_add_var_tab[1], g_var_value);

    /* read the last stored variables data*/
    ee_read_variable(g_virt_add_var_tab[0], &g_var_data_tab[0]);
    ee_read_variable(g_virt_add_var_tab[1], &g_var_data_tab[1]);

    /* Store 0x3000 values of Variable3 in EEPROM */
    for (g_var_value = 1; g_var_value <= 0x3000; g_var_value++)
        ee_write_variable(g_virt_add_var_tab[2], g_var_value);

    /* read the last stored variables data*/
    ee_read_variable(g_virt_add_var_tab[0], &g_var_data_tab[0]);
    ee_read_variable(g_virt_add_var_tab[1], &g_var_data_tab[1]);
    ee_read_variable(g_virt_add_var_tab[2], &g_var_data_tab[2]);

    ee_write_variable(g_virt_add_var_tab[0], 0x1234);
    ee_write_variable(g_virt_add_var_tab[1], 0x8765);
    ee_write_variable(g_virt_add_var_tab[2], 0x55AA);
    ee_read_variable(g_virt_add_var_tab[0], &g_var_data_tab[0]);
    ee_read_variable(g_virt_add_var_tab[1], &g_var_data_tab[1]);
    ee_read_variable(g_virt_add_var_tab[2], &g_var_data_tab[2]);

    __enable_irq();

    while (1);
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
