/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    30 Oct 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Oct 2021     biyq          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"
#include <stdio.h>
#include "crc32.h"

/* Public Variables ---------------------------------------------------------- */
/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
static uint32_t crc_buf[8] = {1U, 2U, 3U, 4U, 5U, 6U, 7U, 8U};
static uint32_t crc_result = 0x0U;


/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */

void gpio_init(void);
void usart_init(void);

/* Private Function ---------------------------------------------------------- */
/**
  * @brief  Initializate system.
  * @retval None
  */
void SystemInit(void)
{

}

/**
  * @brief:  Main program.
  * @param:  None
  * @retval: None
  */
int main()
{
    /* Configure system clock */
    md_cmu_clock_config(MD_CMU_CLOCK_HRC, 32000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    /* Init GPIO */
    gpio_init();

    /* Init UART */
    usart_init();

    /* Init CRC32 */
    init_crc32_module();

    /* Calculate CRC32 value for array crc_buf */
    crc_result = get_crc32_calculation_result(crc_buf, (sizeof(crc_buf) / 4));

    /* Delay 7S and output value */
    md_delay_1ms(1000);
    printf("CRC32 calculation result for 0x00 ~ 0x08 is: 0x%.8X", crc_result);



    while (1)
    {
        md_gpio_toggle_pin_output(LED_PORT, LED_PIN);
        md_delay_1ms(1000);
    }
}

/**
  * @brief:  Init gpio for led and usart.
  * @param:  None
  * @retval: None
  */
void gpio_init()
{

    md_gpio_init_t g_gpio_init_s;

    md_gpio_init_struct(&g_gpio_init_s);

    g_gpio_init_s.mode = MD_GPIO_MODE_OUTPUT;
    md_gpio_init(LED_PORT, LED_PIN, &g_gpio_init_s);
    md_gpio_set_pin_low(LED_PORT, LED_PIN);

    g_gpio_init_s.mode = MD_GPIO_MODE_OUTPUT;
    g_gpio_init_s.func = MD_GPIO_FUNC_3;
    md_gpio_init(USART_PORT, USART_TX_PIN, &g_gpio_init_s);

    g_gpio_init_s.mode = MD_GPIO_MODE_INPUT;
    md_gpio_init(USART_PORT, USART_RX_PIN, &g_gpio_init_s);
}

/**
  * @brief:  Init usart configuration.
  * @param:  None
  * @retval: None
  */
void usart_init()
{

    md_usart_init_t g_usart_init_s;
    md_usart_init_struct(&g_usart_init_s);

    md_usart_init(USART0, &g_usart_init_s);
}

/**
  * @brief:  Rewrite fputc.
  * @param:  None
  * @retval: None
  */
int fputc(int c, FILE *f)
{
    while ((READ_BIT(USART0->STAT, USART_STAT_TXEMPIF_MSK)) != USART_STAT_TXEMPIF_MSK);

    USART0->DATA = (uint8_t)c;
    return c;

}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
