/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Variables --------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
/* Private Macros ------------------------------------------------------------ */
//#define TEST_ADDR   0x3000
#define TEST_ADDR   0x3000
#define TEST_LEN    0x20
/* Public Variables ---------------------------------------------------------- */

/* Private Function ---------------------------------------------------------- */
void SystemInit()
{

}

/**
  * @brief  Initializate pin.
  * @retval None
  */
void init_gpio(void)
{
    md_gpio_init_t gpio_init;

    /* Initialize LED pin */
    md_gpio_init_struct(&gpio_init);      /* initialize the gpio_init */
    gpio_init.mode  = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_FLOATING;
    gpio_init.odrv  = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.func  = MD_GPIO_FUNC_1;
    md_gpio_init(LED_PORT, LED_PIN, &gpio_init);

    return;
}
/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    uint32_t data_buf[TEST_LEN];
    uint32_t iap_flag;
    /* Configure system clock */
    md_cmu_clock_config(MD_CMU_CLOCK_HRC, 32000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();
    /* Initialize pin */
    init_gpio();
    md_gpio_set_pin_high(LED_PORT, LED_PIN);

    __disable_irq();

    do
    {

        iap_flag = FALSE;

        /* Erase flash */
        if (md_msc_code_erase_page(TEST_ADDR, ~TEST_ADDR) != RESET)
            break;

        if (md_msc_code_program_word(TEST_ADDR, ~TEST_ADDR, 0x12345678) != RESET)
            break;

        /* Read data from the flash address */
        memcpy((void *)data_buf, (void *)TEST_ADDR, 4);

        if (data_buf[0] != 0x12345678)
            break;

        /* Multiple words write testing */
        memset((void *)data_buf, 0x55, TEST_LEN * 4);
        FLASH_REG_UNLOCK();

        /* Write data to flash */
        if (md_msc_code_program_words(TEST_ADDR, ~TEST_ADDR, (uint8_t *)data_buf, TEST_LEN * 4, AUTO_ERASE_TRUE) != RESET)
            break;

        if (memcmp((void *)TEST_ADDR, (void *)data_buf, TEST_LEN * 4) != 0)
            break;

        iap_flag = TRUE;
        break;
    }
    while (0);

    __enable_irq();

    while (1)
    {
        if (iap_flag == TRUE)                          /* If iap is succesful */
            md_gpio_set_pin_low(LED_PORT, LED_PIN);    /* Turn on the led */
    }
}
/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
