/**********************************************************************************
 *
 * @file    usart_print.c
 * @brief   usart_print C file
 *
 * @date    26 Aug 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          26 Aug 2022     biyq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <stdio.h>
#include "usart_print.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

static md_usart_init_t s_usart;

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

static void usart_pin_init(void);

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  usart function
  * @retval None.
  */
void usart_init(void)
{
    usart_pin_init();

    s_usart.mode        = MD_USART_MODE_TX_RX;
    s_usart.baud        = 115200;
    s_usart.word_length = MD_USART_WORD_LENGTH_8B;
    s_usart.stop_bits   = MD_USART_STOP_BITS_1;
    s_usart.parity      = MD_USART_PARITY_NONE;
    s_usart.fctl        = MD_USART_HW_FLOW_CTL_NONE;

    md_usart_init(USART0, &s_usart);  /*Initialization and USART, parameter 8 1 N 115200*/
}

/**
  * @brief  usart pin function
  * @retval None.
  */
static void usart_pin_init(void)
{
    md_gpio_init_t l_gpio;

    l_gpio.func  = MD_GPIO_FUNC_3;
    l_gpio.type  = MD_GPIO_TYPE_CMOS;
    l_gpio.mode  = MD_GPIO_MODE_OUTPUT;
    l_gpio.odos  = MD_GPIO_PUSH_PULL;
    l_gpio.pupd  = MD_GPIO_PUSH_UP;
    l_gpio.odrv  = MD_GPIO_OUT_DRIVE_NORMAL;
    l_gpio.flt   = MD_GPIO_FILTER_DISABLE;
    md_gpio_init(GPIOA, MD_GPIO_PIN_13, &l_gpio);   /*Initializes the TX pin*/

    l_gpio.mode  = MD_GPIO_MODE_INPUT;
    md_gpio_init(GPIOA, MD_GPIO_PIN_14, &l_gpio);   /*Apart from the pin direction for input configuration is the same as the TX pin*/
}

/**
  * @brief  fput function
  * @retval None.
  */
int fputc(int c, FILE *f)   /*Redirect printf output to the serial port*/
{
    while ((READ_BIT(USART0->STAT, USART_STAT_TXEMPIF_MSK)) != USART_STAT_TXEMPIF_MSK);  /*Waiting on the completion of a byte*/
    md_usart_send_data8(USART0, (uint8_t)c);    /*USART send*/
	
    return c;
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
