/**********************************************************************************
 *
 * @file    timer.c
 * @brief   timer C file
 *
 * @date    25 Aug 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 Aug 2022     biyq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "timer.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */

/**
  * @brief:  Initialize BS16TN to timely overflow funtion
  * @param:  cnt: the number of count
  * @retval: None
  */
void init_timer(uint32_t cnt)
{
    md_timer_base_init_t bs16tn_init;

    md_timer_base_struct_init(&bs16tn_init);	/* initialize the bs16tn_init  */
    bs16tn_init.prescaler = 32 - 1;				/* clk_count: 1MHz */
    bs16tn_init.mode = MD_TIMER_CNT_MODE_UP;	/* count up */
    bs16tn_init.period = cnt - 1;             /* period is 10000 count clock */
    bs16tn_init.re_cnt = 1 - 1;					/* 0 repeat count */
    md_timer_base_set_config(BS16TN, &bs16tn_init);
    md_timer_enable_uit_interrupt(BS16TN);		/* enable updata interrupt */

    /* Set priority for BSTIM0_IRQn */
    NVIC_SetPriority(BSTIM0_IRQn, 0);

    /* Enable BSTIM0_IRQn */
    NVIC_EnableIRQ(BSTIM0_IRQn);

    /* enable BS16TN */
    md_timer_enable_counter_cnten(BS16TN);
	
	return;
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
