/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    14 Aug 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          14 Aug 2022     biyq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include "main.h"

/* Private Macros ------------------------------------------------------------ */
#define SINGLE_SHOT		0

/* Private Variables --------------------------------------------------------- */
uint8_t txbuf[5];
uint8_t rxbuf[6];
uint8_t status;
uint32_t run_cycle;

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Initializate system.
  * @retval None
  */
void SystemInit(void)
{

}

/**
  * @brief  Main function.
  * @param  None.
  * @retval None
  */
int main(void)
{
    /* Configure system clock */
    md_cmu_clock_config(MD_CMU_CLOCK_HRC, 32000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    /* usart initialization */
	usart_init();
	
    /* I2C initialization */
    sw_i2c_sensor_init();
	printf("test start\r\n");
	
    /* timer initialization */
	init_timer(200);
	
#if !SINGLE_SHOT	
	/* sensor run */
	txbuf[0] = 0x03;
	status = sw_i2c_sensor_write(SENSOR_ADDR, 0x21, txbuf, 1);
	if (status)
	{
		printf("write sensor failed\r\n");
	}
	md_delay_1ms(500);
	
	/* sensor start */
	txbuf[0] = 0x03;
	status = sw_i2c_sensor_write(SENSOR_ADDR, 0x22, txbuf, 1);
	if (status)
	{
		printf("write sensor failed\r\n");
	}
	md_delay_1ms(300);
#endif

    while (1)
	{
	
#if SINGLE_SHOT	
		/* sensor run */
		txbuf[0] = 0x03;
		sw_i2c_sensor_write(SENSOR_ADDR, 0x22, txbuf, 1);
		if (status != 1)
		{
			printf("sensor control failed\r\n");
		}
		md_delay_1ms(300);
	
#endif		
		
		run_cycle++;
		status = sw_i2c_sensor_read(SENSOR_ADDR, 0x30, rxbuf, 6);
		if (status)
		{
			printf("sensor read failed\r\n");
		}
		
		status = sw_i2c_sensor_crc_verify(rxbuf, 6);
		if (status)
		{
			printf("running cycle: %d\r\n", run_cycle);
			printf("%.2x %.2x %.2x %.2x %.2x %.2x\r\n", rxbuf[0], rxbuf[1], rxbuf[2], rxbuf[3], rxbuf[4], rxbuf[5]);
		}
		
		if (run_cycle % 1000 == 0)
		{
			printf("test complete 1000 cycle\r\n");
			run_cycle = 0;
		}
		md_delay_1ms(300);
	}
}

/**
  * @} Examples_I2C
  */

/**
  * @} Projects_Examples_MD
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
