/**********************************************************************************
 *
 * @file    ens210.h
 * @brief   header file of ens210.c
 *
 * @date    25 Aug 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 Aug 2022     biyq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __ENS210_H__
#define   __ENS210_H__

/* Includes ------------------------------------------------------------------ */
#include "md_conf.h"

	
/* Exported Macros ----------------------------------------------------------- */

/* Exported Types ------------------------------------------------------------ */

/* Exported Variables -------------------------------------------------------- */

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */

/* Exported Functions Prototype ------------------------------------------- */
void sw_i2c_sensor_init(void);
uint8_t sw_i2c_sensor_write(uint8_t sensor_addr, uint8_t reg_addr, uint8_t *tx_buf, uint32_t len);
uint8_t sw_i2c_sensor_read(uint8_t sensor_addr, uint8_t reg_addr, uint8_t *rx_buf, uint32_t len);
uint8_t sw_i2c_sensor_crc_verify(uint8_t *rx_buf, uint8_t len);

#endif     /*__I2C_SENSOR_H__*/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
